/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.application.converter;

import cn.ponfee.disjob.core.base.SupervisorMetrics;
import cn.ponfee.disjob.core.base.WorkerMetrics;
import cn.ponfee.disjob.supervisor.application.converter.MapstructMapper;
import cn.ponfee.disjob.supervisor.application.converter.ServerMetricsConverter;
import cn.ponfee.disjob.supervisor.application.response.SupervisorMetricsResponse;
import cn.ponfee.disjob.supervisor.application.response.WorkerMetricsResponse;

public class ServerMetricsConverterImpl
implements ServerMetricsConverter {
    private final MapstructMapper mapstructMapper = new MapstructMapper();

    @Override
    public SupervisorMetricsResponse convert(SupervisorMetrics metrics) {
        if (metrics == null) {
            return null;
        }
        SupervisorMetricsResponse supervisorMetricsResponse = new SupervisorMetricsResponse();
        supervisorMetricsResponse.setStartupAt(this.mapstructMapper.asString(metrics.getStartupAt()));
        supervisorMetricsResponse.setAlsoWorker(metrics.isAlsoWorker());
        return supervisorMetricsResponse;
    }

    @Override
    public WorkerMetricsResponse convert(WorkerMetrics metrics) {
        if (metrics == null) {
            return null;
        }
        WorkerMetricsResponse workerMetricsResponse = new WorkerMetricsResponse();
        workerMetricsResponse.setClosed(this.metricsThreadPoolClosed(metrics));
        workerMetricsResponse.setKeepAliveTime(this.metricsThreadPoolKeepAliveTime(metrics));
        workerMetricsResponse.setMaximumPoolSize(this.metricsThreadPoolMaximumPoolSize(metrics));
        workerMetricsResponse.setCurrentPoolSize(this.metricsThreadPoolCurrentPoolSize(metrics));
        workerMetricsResponse.setActivePoolSize(this.metricsThreadPoolActivePoolSize(metrics));
        workerMetricsResponse.setIdlePoolSize(this.metricsThreadPoolIdlePoolSize(metrics));
        workerMetricsResponse.setQueueTaskCount(this.metricsThreadPoolQueueTaskCount(metrics));
        workerMetricsResponse.setCompletedTaskCount(this.metricsThreadPoolCompletedTaskCount(metrics));
        workerMetricsResponse.setStartupAt(this.mapstructMapper.asString(metrics.getStartupAt()));
        workerMetricsResponse.setAlsoSupervisor(metrics.isAlsoSupervisor());
        workerMetricsResponse.setJvmThreadActiveCount(metrics.getJvmThreadActiveCount());
        return workerMetricsResponse;
    }

    private Boolean metricsThreadPoolClosed(WorkerMetrics workerMetrics) {
        if (workerMetrics == null) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if (threadPool == null) {
            return null;
        }
        boolean closed = threadPool.isClosed();
        return closed;
    }

    private Integer metricsThreadPoolKeepAliveTime(WorkerMetrics workerMetrics) {
        if (workerMetrics == null) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if (threadPool == null) {
            return null;
        }
        int keepAliveTime = threadPool.getKeepAliveTime();
        return keepAliveTime;
    }

    private Integer metricsThreadPoolMaximumPoolSize(WorkerMetrics workerMetrics) {
        if (workerMetrics == null) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if (threadPool == null) {
            return null;
        }
        int maximumPoolSize = threadPool.getMaximumPoolSize();
        return maximumPoolSize;
    }

    private Integer metricsThreadPoolCurrentPoolSize(WorkerMetrics workerMetrics) {
        if (workerMetrics == null) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if (threadPool == null) {
            return null;
        }
        int currentPoolSize = threadPool.getCurrentPoolSize();
        return currentPoolSize;
    }

    private Integer metricsThreadPoolActivePoolSize(WorkerMetrics workerMetrics) {
        if (workerMetrics == null) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if (threadPool == null) {
            return null;
        }
        int activePoolSize = threadPool.getActivePoolSize();
        return activePoolSize;
    }

    private Integer metricsThreadPoolIdlePoolSize(WorkerMetrics workerMetrics) {
        if (workerMetrics == null) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if (threadPool == null) {
            return null;
        }
        int idlePoolSize = threadPool.getIdlePoolSize();
        return idlePoolSize;
    }

    private Long metricsThreadPoolQueueTaskCount(WorkerMetrics workerMetrics) {
        if (workerMetrics == null) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if (threadPool == null) {
            return null;
        }
        long queueTaskCount = threadPool.getQueueTaskCount();
        return queueTaskCount;
    }

    private Long metricsThreadPoolCompletedTaskCount(WorkerMetrics workerMetrics) {
        if (workerMetrics == null) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if (threadPool == null) {
            return null;
        }
        long completedTaskCount = threadPool.getCompletedTaskCount();
        return completedTaskCount;
    }
}

