/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.application.request;

import cn.ponfee.disjob.common.base.ToJsonString;
import cn.ponfee.disjob.core.model.SchedGroup;
import cn.ponfee.disjob.supervisor.application.converter.SchedGroupConverter;
import java.io.Serializable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class UpdateSchedGroupRequest
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = 7531416191031943146L;
    private String group;
    private String ownUser;
    private String devUsers;
    private String alarmUsers;
    private String webHook;
    private String updatedBy;
    private int version;

    public SchedGroup toSchedGroup() {
        return SchedGroupConverter.INSTANCE.convert(this);
    }

    public void checkAndTrim() {
        Assert.hasText((String)this.updatedBy, (String)"Updated by cannot be blank.");
        this.ownUser = StringUtils.trim((String)this.ownUser);
        this.devUsers = UpdateSchedGroupRequest.prune(this.devUsers);
        this.alarmUsers = UpdateSchedGroupRequest.prune(this.alarmUsers);
        this.webHook = StringUtils.trim((String)this.webHook);
    }

    private static String prune(String users) {
        if (users == null) {
            return null;
        }
        return Stream.of(users.split(",")).filter(StringUtils::isNotBlank).map(String::trim).distinct().collect(Collectors.joining(","));
    }

    public String getGroup() {
        return this.group;
    }

    public String getOwnUser() {
        return this.ownUser;
    }

    public String getDevUsers() {
        return this.devUsers;
    }

    public String getAlarmUsers() {
        return this.alarmUsers;
    }

    public String getWebHook() {
        return this.webHook;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public int getVersion() {
        return this.version;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setOwnUser(String ownUser) {
        this.ownUser = ownUser;
    }

    public void setDevUsers(String devUsers) {
        this.devUsers = devUsers;
    }

    public void setAlarmUsers(String alarmUsers) {
        this.alarmUsers = alarmUsers;
    }

    public void setWebHook(String webHook) {
        this.webHook = webHook;
    }

    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

