/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.application.value;

import cn.ponfee.disjob.core.model.SchedGroup;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class DisjobGroup {
    private final String supervisorToken;
    private final String workerToken;
    private final String userToken;
    private final String ownUser;
    private final Set<String> alarmUsers;
    private final Set<String> devUsers;
    private final String webHook;

    private DisjobGroup(String supervisorToken, String workerToken, String userToken, String ownUser, Set<String> devUsers, Set<String> alarmUsers, String webHook) {
        this.supervisorToken = supervisorToken;
        this.workerToken = workerToken;
        this.userToken = userToken;
        this.ownUser = ownUser;
        this.devUsers = devUsers;
        this.alarmUsers = alarmUsers;
        this.webHook = webHook;
    }

    public static DisjobGroup of(SchedGroup schedGroup) {
        String ownUser = schedGroup.getOwnUser();
        return new DisjobGroup(schedGroup.getSupervisorToken(), schedGroup.getWorkerToken(), schedGroup.getUserToken(), ownUser, DisjobGroup.parse(schedGroup.getDevUsers(), ownUser), DisjobGroup.parse(schedGroup.getAlarmUsers(), ownUser), schedGroup.getWebHook());
    }

    public boolean isDeveloper(String user) {
        return this.devUsers.contains(user);
    }

    private static Set<String> parse(String str, String ownUser) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return Collections.singleton(ownUser);
        }
        String[] array = str.split(",");
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)(array.length + 1));
        builder.add((Object)ownUser);
        Stream.of(array).filter(StringUtils::isNotBlank).forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        return builder.build();
    }

    public String getSupervisorToken() {
        return this.supervisorToken;
    }

    public String getWorkerToken() {
        return this.workerToken;
    }

    public String getUserToken() {
        return this.userToken;
    }

    public String getOwnUser() {
        return this.ownUser;
    }

    public Set<String> getAlarmUsers() {
        return this.alarmUsers;
    }

    public Set<String> getDevUsers() {
        return this.devUsers;
    }

    public String getWebHook() {
        return this.webHook;
    }
}

