/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.auth;

import cn.ponfee.disjob.core.exception.AuthenticationException;
import cn.ponfee.disjob.supervisor.application.SchedGroupService;
import cn.ponfee.disjob.supervisor.application.value.DisjobGroup;
import cn.ponfee.disjob.supervisor.auth.SupervisorAuthentication;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public class AuthenticationConfigurer
implements WebMvcConfigurer {
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new AuthenticationInterceptor()).order(Integer.MIN_VALUE);
    }

    private static class AuthenticationInterceptor
    implements HandlerInterceptor {
        private static final String ERR_MSG = "Authenticate failed.";

        private AuthenticationInterceptor() {
        }

        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
            if (!(handler instanceof HandlerMethod)) {
                return true;
            }
            SupervisorAuthentication annotation = AuthenticationInterceptor.getAnnotation((HandlerMethod)handler);
            if (annotation == null || annotation.value() == SupervisorAuthentication.Subject.ANON) {
                return true;
            }
            String group = request.getHeader("X-Disjob-Group");
            if (StringUtils.isBlank((CharSequence)group)) {
                throw new AuthenticationException(ERR_MSG);
            }
            SupervisorAuthentication.Subject value = annotation.value();
            if (value == SupervisorAuthentication.Subject.WORKER) {
                AuthenticationInterceptor.authenticateWorker(request, group);
            } else if (value == SupervisorAuthentication.Subject.USER) {
                AuthenticationInterceptor.authenticateUser(request, group);
            } else {
                throw new UnsupportedOperationException("Unsupported supervisor authentication subject: " + (Object)((Object)annotation.value()));
            }
            return true;
        }

        private static void authenticateWorker(HttpServletRequest request, String group) {
            String workerToken = SchedGroupService.mapGroup(group).getWorkerToken();
            if (StringUtils.isBlank((CharSequence)workerToken)) {
                return;
            }
            String token = request.getHeader("X-Disjob-Token");
            if (!workerToken.equals(token)) {
                throw new AuthenticationException(ERR_MSG);
            }
        }

        private static void authenticateUser(HttpServletRequest request, String group) {
            String user = request.getHeader("X-Disjob-User");
            DisjobGroup disjobGroup = SchedGroupService.mapGroup(group);
            if (!disjobGroup.isDeveloper(user)) {
                throw new AuthenticationException(ERR_MSG);
            }
            String userToken = SchedGroupService.mapGroup(group).getUserToken();
            if (StringUtils.isBlank((CharSequence)userToken)) {
                throw new AuthenticationException(ERR_MSG);
            }
            String token = request.getHeader("X-Disjob-Token");
            if (!userToken.equals(token)) {
                throw new AuthenticationException(ERR_MSG);
            }
            request.setAttribute("disjob_user", (Object)disjobGroup);
        }

        private static SupervisorAuthentication getAnnotation(HandlerMethod hm) {
            SupervisorAuthentication a = (SupervisorAuthentication)hm.getMethodAnnotation(SupervisorAuthentication.class);
            return a != null ? a : hm.getBeanType().getAnnotation(SupervisorAuthentication.class);
        }
    }
}

