/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.base;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.io.VFS;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.boot.autoconfigure.SpringBootVFS;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public abstract class AbstractDataSourceConfig {
    public static final String DATA_SOURCE_NAME_SUFFIX = "DataSource";
    public static final String SQL_SESSION_FACTORY_NAME_SUFFIX = "SqlSessionFactory";
    public static final String SQL_SESSION_TEMPLATE_NAME_SUFFIX = "SqlSessionTemplate";
    public static final String TX_MANAGER_NAME_SUFFIX = "TransactionManager";
    public static final String TX_TEMPLATE_NAME_SUFFIX = "TransactionTemplate";
    public static final String JDBC_TEMPLATE_NAME_SUFFIX = "JdbcTemplate";
    private final String mybatisMapperFileLocation;

    public AbstractDataSourceConfig() {
        this(-1);
    }

    public AbstractDataSourceConfig(int wildcardLastIndex) {
        String path;
        List list = Arrays.stream(ClassUtils.getPackageName(this.getClass()).split("\\.")).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        if (list.size() == 0) {
            path = "";
        } else if (wildcardLastIndex == 0) {
            path = String.join((CharSequence)"/", list) + "/**/";
        } else if (wildcardLastIndex < 0) {
            path = String.join((CharSequence)"/", list) + "/";
        } else if (list.size() <= wildcardLastIndex) {
            path = "/**/" + String.join((CharSequence)"/", list) + "/";
        } else {
            int pos = list.size() - wildcardLastIndex;
            path = String.join((CharSequence)"/", list.subList(0, pos)) + "/**/" + String.join((CharSequence)"/", list.subList(pos, list.size())) + "/";
        }
        this.mybatisMapperFileLocation = MessageFormat.format("classpath*:{0}xml/*.xml", path);
    }

    public AbstractDataSourceConfig(String mybatisMapperFileLocation) {
        this.mybatisMapperFileLocation = mybatisMapperFileLocation;
    }

    public abstract DataSource dataSource();

    protected final SqlSessionFactory createSqlSessionFactory() throws Exception {
        VFS.addImplClass(SpringBootVFS.class);
        SqlSessionFactoryBean factoryBean = new SqlSessionFactoryBean();
        factoryBean.setDataSource(this.dataSource());
        factoryBean.setConfiguration(AbstractDataSourceConfig.createMybatisConfiguration());
        factoryBean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources(this.mybatisMapperFileLocation));
        return factoryBean.getObject();
    }

    private static Configuration createMybatisConfiguration() {
        Configuration configuration = new Configuration();
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setDefaultFetchSize(Integer.valueOf(100));
        configuration.setDefaultStatementTimeout(Integer.valueOf(25));
        return configuration;
    }
}

