/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.base;

import cn.ponfee.disjob.core.base.HttpProperties;
import cn.ponfee.disjob.core.base.RetryProperties;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.base.WorkerMetrics;
import cn.ponfee.disjob.core.base.WorkerRpcService;
import cn.ponfee.disjob.core.exception.JobException;
import cn.ponfee.disjob.core.handle.JobHandlerUtils;
import cn.ponfee.disjob.core.handle.SplitTask;
import cn.ponfee.disjob.core.param.worker.JobHandlerParam;
import cn.ponfee.disjob.registry.Discovery;
import cn.ponfee.disjob.registry.DiscoveryRestProxy;
import cn.ponfee.disjob.registry.DiscoveryRestTemplate;
import cn.ponfee.disjob.registry.SupervisorRegistry;
import cn.ponfee.disjob.supervisor.application.SchedGroupService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import javax.annotation.Nullable;

public class WorkerRpcClient {
    private final Worker.Current currentWorker;
    private final WorkerRpcService local;
    private final WorkerRpcService remote;

    public WorkerRpcClient(HttpProperties httpProperties, RetryProperties retryProperties, SupervisorRegistry supervisorRegistry, @Nullable Worker.Current currentWorker, @Nullable ObjectMapper objectMapper) {
        httpProperties.check();
        retryProperties.check();
        DiscoveryRestTemplate discoveryRestTemplate = DiscoveryRestTemplate.builder().httpConnectTimeout(httpProperties.getConnectTimeout()).httpReadTimeout(httpProperties.getReadTimeout()).retryMaxCount(retryProperties.getMaxCount()).retryBackoffPeriod(retryProperties.getBackoffPeriod()).objectMapper(objectMapper).discoveryServer((Discovery)supervisorRegistry).build();
        this.currentWorker = currentWorker;
        this.local = WorkerRpcLocal.INSTANCE;
        this.remote = (WorkerRpcService)DiscoveryRestProxy.create((boolean)true, WorkerRpcService.class, (DiscoveryRestTemplate)discoveryRestTemplate);
    }

    public void verify(JobHandlerParam param) throws JobException {
        param.setSupervisorToken(SchedGroupService.mapGroup(param.getGroup()).getSupervisorToken());
        this.grouped(param.getGroup()).verify(param);
    }

    public List<SplitTask> split(JobHandlerParam param) throws JobException {
        param.setSupervisorToken(SchedGroupService.mapGroup(param.getGroup()).getSupervisorToken());
        return this.grouped(param.getGroup()).split(param);
    }

    private WorkerRpcService grouped(String group) {
        if (this.currentWorker != null && this.currentWorker.matchesGroup(group)) {
            return this.local;
        }
        ((DiscoveryRestProxy.GroupedServer)this.remote).group(group);
        return this.remote;
    }

    private static class WorkerRpcLocal
    implements WorkerRpcService {
        private static final WorkerRpcLocal INSTANCE = new WorkerRpcLocal();

        private WorkerRpcLocal() {
        }

        public void verify(JobHandlerParam param) throws JobException {
            JobHandlerUtils.verify((JobHandlerParam)param);
        }

        public List<SplitTask> split(JobHandlerParam param) throws JobException {
            return JobHandlerUtils.split((JobHandlerParam)param);
        }

        public WorkerMetrics metrics() {
            throw new UnsupportedOperationException();
        }
    }
}

