package cn.ponfee.disjob.supervisor.application.converter;

import cn.ponfee.disjob.core.base.SupervisorMetrics;
import cn.ponfee.disjob.core.base.WorkerMetrics;
import cn.ponfee.disjob.supervisor.application.response.SupervisorMetricsResponse;
import cn.ponfee.disjob.supervisor.application.response.WorkerMetricsResponse;
import javax.annotation.Generated;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2024-01-13T20:33:11+0800",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 1.8.0_312 (Azul Systems, Inc.)"
)
public class ServerMetricsConverterImpl implements ServerMetricsConverter {

    private final MapstructMapper mapstructMapper = new MapstructMapper();

    @Override
    public SupervisorMetricsResponse convert(SupervisorMetrics metrics) {
        if ( metrics == null ) {
            return null;
        }

        SupervisorMetricsResponse supervisorMetricsResponse = new SupervisorMetricsResponse();

        supervisorMetricsResponse.setStartupAt( mapstructMapper.asString( metrics.getStartupAt() ) );
        supervisorMetricsResponse.setAlsoWorker( metrics.isAlsoWorker() );

        return supervisorMetricsResponse;
    }

    @Override
    public WorkerMetricsResponse convert(WorkerMetrics metrics) {
        if ( metrics == null ) {
            return null;
        }

        WorkerMetricsResponse workerMetricsResponse = new WorkerMetricsResponse();

        workerMetricsResponse.setClosed( metricsThreadPoolClosed( metrics ) );
        workerMetricsResponse.setKeepAliveTime( metricsThreadPoolKeepAliveTime( metrics ) );
        workerMetricsResponse.setMaximumPoolSize( metricsThreadPoolMaximumPoolSize( metrics ) );
        workerMetricsResponse.setCurrentPoolSize( metricsThreadPoolCurrentPoolSize( metrics ) );
        workerMetricsResponse.setActivePoolSize( metricsThreadPoolActivePoolSize( metrics ) );
        workerMetricsResponse.setIdlePoolSize( metricsThreadPoolIdlePoolSize( metrics ) );
        workerMetricsResponse.setQueueTaskCount( metricsThreadPoolQueueTaskCount( metrics ) );
        workerMetricsResponse.setCompletedTaskCount( metricsThreadPoolCompletedTaskCount( metrics ) );
        workerMetricsResponse.setStartupAt( mapstructMapper.asString( metrics.getStartupAt() ) );
        workerMetricsResponse.setAlsoSupervisor( metrics.isAlsoSupervisor() );
        workerMetricsResponse.setJvmThreadActiveCount( metrics.getJvmThreadActiveCount() );

        return workerMetricsResponse;
    }

    private Boolean metricsThreadPoolClosed(WorkerMetrics workerMetrics) {
        if ( workerMetrics == null ) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        boolean closed = threadPool.isClosed();
        return closed;
    }

    private Long metricsThreadPoolKeepAliveTime(WorkerMetrics workerMetrics) {
        if ( workerMetrics == null ) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        long keepAliveTime = threadPool.getKeepAliveTime();
        return keepAliveTime;
    }

    private Integer metricsThreadPoolMaximumPoolSize(WorkerMetrics workerMetrics) {
        if ( workerMetrics == null ) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        int maximumPoolSize = threadPool.getMaximumPoolSize();
        return maximumPoolSize;
    }

    private Integer metricsThreadPoolCurrentPoolSize(WorkerMetrics workerMetrics) {
        if ( workerMetrics == null ) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        int currentPoolSize = threadPool.getCurrentPoolSize();
        return currentPoolSize;
    }

    private Integer metricsThreadPoolActivePoolSize(WorkerMetrics workerMetrics) {
        if ( workerMetrics == null ) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        int activePoolSize = threadPool.getActivePoolSize();
        return activePoolSize;
    }

    private Integer metricsThreadPoolIdlePoolSize(WorkerMetrics workerMetrics) {
        if ( workerMetrics == null ) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        int idlePoolSize = threadPool.getIdlePoolSize();
        return idlePoolSize;
    }

    private Long metricsThreadPoolQueueTaskCount(WorkerMetrics workerMetrics) {
        if ( workerMetrics == null ) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        long queueTaskCount = threadPool.getQueueTaskCount();
        return queueTaskCount;
    }

    private Long metricsThreadPoolCompletedTaskCount(WorkerMetrics workerMetrics) {
        if ( workerMetrics == null ) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        long completedTaskCount = threadPool.getCompletedTaskCount();
        return completedTaskCount;
    }
}
