/* __________              _____                                                *\
** \______   \____   _____/ ____\____   ____    Copyright (c) 2017-2023 Ponfee  **
**  |     ___/  _ \ /    \   __\/ __ \_/ __ \   http://www.ponfee.cn            **
**  |    |  (  <_> )   |  \  | \  ___/\  ___/   Apache License Version 2.0      **
**  |____|   \____/|___|  /__|  \___  >\___  >  http://www.apache.org/licenses/ **
**                      \/          \/     \/                                   **
\*                                                                              */

package cn.ponfee.disjob.supervisor.auth;

import java.lang.annotation.*;

/**
 * Supervisor authentication annotation.
 *
 * @author Ponfee
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
@Documented
public @interface SupervisorAuthentication {

    Subject value();

    enum Subject {
        /**
         * Worker
         */
        WORKER,
        /**
         * User
         */
        USER,
        /**
         * Anonymous
         */
        ANON,
    }

}
