/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.application;

import cn.ponfee.disjob.common.concurrent.ThreadPoolExecutors;
import cn.ponfee.disjob.common.exception.Throwables;
import cn.ponfee.disjob.core.param.supervisor.EventParam;
import cn.ponfee.disjob.supervisor.application.SchedGroupService;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class EventSubscribeService {
    private static final Logger LOG = LoggerFactory.getLogger(EventSubscribeService.class);
    private static final ConcurrentMap<EventParam.Type, EventParam> MAP = new ConcurrentHashMap<EventParam.Type, EventParam>();
    private final SchedGroupService schedGroupService;

    public EventSubscribeService(SchedGroupService schedGroupService) {
        this.schedGroupService = schedGroupService;
        long initialDelay = 5000L + ThreadLocalRandom.current().nextLong(5000L);
        ThreadPoolExecutors.commonScheduledPool().scheduleWithFixedDelay(this::process, initialDelay, 5000L, TimeUnit.MILLISECONDS);
    }

    public static void subscribe(EventParam param) {
        if (param != null && param.getType() != null) {
            MAP.compute(param.getType(), (k, v) -> param);
        }
    }

    private void process() {
        HashSet types = new HashSet(MAP.keySet());
        for (EventParam.Type type : types) {
            Throwables.ThrowingRunnable.doCaught(() -> this.process((EventParam)MAP.remove(type)));
        }
    }

    private void process(EventParam param) {
        if (param == null) {
            return;
        }
        EventParam.Type type = param.getType();
        if (type == EventParam.Type.REFRESH_GROUP) {
            this.schedGroupService.refresh();
        } else {
            LOG.error("Unsupported subscribe event type: {}", (Object)type);
        }
    }
}

