/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.component;

import cn.ponfee.disjob.common.base.IdGenerator;
import cn.ponfee.disjob.common.date.Dates;
import cn.ponfee.disjob.common.model.CodeMsg;
import cn.ponfee.disjob.common.spring.TransactionUtils;
import cn.ponfee.disjob.core.base.JobCodeMsg;
import cn.ponfee.disjob.core.base.Server;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.base.WorkerRpcService;
import cn.ponfee.disjob.core.enums.ExecuteState;
import cn.ponfee.disjob.core.enums.JobState;
import cn.ponfee.disjob.core.enums.Operation;
import cn.ponfee.disjob.core.enums.RouteStrategy;
import cn.ponfee.disjob.core.enums.TriggerType;
import cn.ponfee.disjob.core.exception.JobException;
import cn.ponfee.disjob.core.exception.KeyExistsException;
import cn.ponfee.disjob.core.handle.SplitTask;
import cn.ponfee.disjob.core.model.SchedDepend;
import cn.ponfee.disjob.core.model.SchedInstance;
import cn.ponfee.disjob.core.model.SchedJob;
import cn.ponfee.disjob.core.model.SchedTask;
import cn.ponfee.disjob.core.param.worker.AuthenticationParam;
import cn.ponfee.disjob.core.param.worker.JobHandlerParam;
import cn.ponfee.disjob.dispatch.ExecuteTaskParam;
import cn.ponfee.disjob.dispatch.TaskDispatcher;
import cn.ponfee.disjob.registry.SupervisorRegistry;
import cn.ponfee.disjob.registry.rpc.DiscoveryServerRestProxy;
import cn.ponfee.disjob.supervisor.application.SchedGroupService;
import cn.ponfee.disjob.supervisor.dao.mapper.SchedDependMapper;
import cn.ponfee.disjob.supervisor.dao.mapper.SchedJobMapper;
import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public abstract class AbstractJobManager {
    private static final int MAX_SPLIT_TASK_SIZE = 1000;
    private static final int MAX_DEPENDS_LEVEL = 20;
    protected final SchedJobMapper jobMapper;
    protected final SchedDependMapper dependMapper;
    private final IdGenerator idGenerator;
    private final SupervisorRegistry workerDiscover;
    private final TaskDispatcher taskDispatcher;
    private final DiscoveryServerRestProxy.GroupedServerInvoker<WorkerRpcService> workerRpcServiceClient;

    public boolean disableJob(SchedJob job) {
        return TransactionUtils.isOneAffectedRow((int)this.jobMapper.disable(job));
    }

    public boolean changeJobState(long jobId, JobState to) {
        boolean flag = TransactionUtils.isOneAffectedRow((int)this.jobMapper.updateState(jobId, to.value(), 1 ^ to.value()));
        if (flag && to == JobState.ENABLE) {
            SchedJob job = this.jobMapper.get(jobId);
            this.updateFixedDelayNextTriggerTime(job, Dates.ofTimeMillis((Long)job.getLastTriggerTime()));
        }
        return flag;
    }

    public boolean updateJobNextTriggerTime(SchedJob job) {
        return TransactionUtils.isOneAffectedRow((int)this.jobMapper.updateNextTriggerTime(job));
    }

    public boolean updateJobNextScanTime(SchedJob schedJob) {
        return TransactionUtils.isOneAffectedRow((int)this.jobMapper.updateNextScanTime(schedJob));
    }

    @Transactional(transactionManager="disjobTransactionManager", rollbackFor={Exception.class})
    public Long addJob(SchedJob job) throws JobException {
        if (this.jobMapper.exists(job.getGroup(), job.getJobName())) {
            throw new KeyExistsException("[" + job.getGroup() + "] already exists job name: " + job.getJobName());
        }
        job.setUpdatedBy(job.getCreatedBy());
        job.verifyBeforeAdd();
        job.checkAndDefaultSetting();
        this.verifyJob(job);
        job.setJobId(Long.valueOf(this.generateId()));
        this.parseTriggerConfig(job);
        this.jobMapper.insert(job);
        return job.getJobId();
    }

    @Transactional(transactionManager="disjobTransactionManager", rollbackFor={Exception.class})
    public void updateJob(SchedJob job) throws JobException {
        job.verifyBeforeUpdate();
        job.checkAndDefaultSetting();
        if (StringUtils.isEmpty((CharSequence)job.getJobHandler())) {
            Assert.hasText((String)job.getJobParam(), (String)"Job param must be null if not set job handler.");
        } else {
            this.verifyJob(job);
        }
        SchedJob dbJob = this.jobMapper.get(job.getJobId());
        Assert.notNull((Object)dbJob, () -> "Sched job id not found " + job.getJobId());
        Assert.isTrue((boolean)dbJob.getGroup().equals(job.getGroup()), (String)"Cannot modify job group.");
        job.setNextTriggerTime(dbJob.getNextTriggerTime());
        if (job.getTriggerType() == null) {
            Assert.isNull((Object)job.getTriggerValue(), (String)"Trigger value must be null if not set trigger type.");
        } else if (!dbJob.equalsTrigger(job.getTriggerType(), job.getTriggerValue())) {
            Assert.notNull((Object)job.getTriggerValue(), (String)"Trigger value cannot be null if has set trigger type.");
            this.dependMapper.deleteByChildJobId(job.getJobId());
            this.parseTriggerConfig(job);
        }
        job.setUpdatedAt(new Date());
        TransactionUtils.assertOneAffectedRow((int)this.jobMapper.update(job), (String)"Update sched job fail or conflict.");
    }

    @Transactional(transactionManager="disjobTransactionManager", rollbackFor={Exception.class})
    public void deleteJob(long jobId) {
        SchedJob job = this.jobMapper.get(jobId);
        Assert.notNull((Object)job, (String)("Job id not found: " + jobId));
        if (JobState.ENABLE.equals(job.getJobState())) {
            throw new IllegalStateException("Please disable job before delete this job.");
        }
        TransactionUtils.assertOneAffectedRow((int)this.jobMapper.softDelete(jobId), (String)"Delete sched job fail or conflict.");
        this.dependMapper.deleteByParentJobId(jobId);
        this.dependMapper.deleteByChildJobId(jobId);
    }

    protected boolean updateFixedDelayNextTriggerTime(SchedJob job, Date baseTime) {
        TriggerType fixedDelay = TriggerType.FIXED_DELAY;
        if (!fixedDelay.equals(job.getTriggerType())) {
            return false;
        }
        Date date = baseTime == null ? null : fixedDelay.computeNextTriggerTime(job.getTriggerValue(), baseTime);
        Date nextTriggerTime = Dates.max((Date)new Date(), (Date)job.getStartTime(), (Date)date);
        return TransactionUtils.isOneAffectedRow((int)this.jobMapper.updateFixedDelayNextTriggerTime(job.getJobId(), nextTriggerTime.getTime()));
    }

    public long generateId() {
        return this.idGenerator.generateId();
    }

    public List<SchedTask> splitTasks(JobHandlerParam param, long instanceId, Date date) throws JobException {
        if (RouteStrategy.BROADCAST == param.getRouteStrategy()) {
            List discoveredServers = this.workerDiscover.getDiscoveredServers(param.getGroup());
            if (discoveredServers.isEmpty()) {
                throw new JobException((CodeMsg)JobCodeMsg.NOT_DISCOVERED_WORKER);
            }
            int count = discoveredServers.size();
            return IntStream.range(0, count).mapToObj(i -> SchedTask.create((String)param.getJobParam(), (long)this.generateId(), (long)instanceId, (int)(i + 1), (int)count, (Date)date, (String)((Worker)discoveredServers.get(i)).serialize())).collect(Collectors.toList());
        }
        List<SplitTask> split = this.splitJob(param);
        Assert.notEmpty(split, () -> "Not split any task: " + param);
        Assert.isTrue((split.size() <= 1000 ? 1 : 0) != 0, () -> "Split task size must less than 1000, job=" + param);
        int count = split.size();
        return IntStream.range(0, count).mapToObj(i -> SchedTask.create((String)Optional.ofNullable(split.get(i)).map(SplitTask::getTaskParam).orElse(null), (long)this.generateId(), (long)instanceId, (int)(i + 1), (int)count, (Date)date, null)).collect(Collectors.toList());
    }

    public boolean hasAliveExecuting(List<SchedTask> tasks) {
        if (CollectionUtils.isEmpty(tasks)) {
            return false;
        }
        return tasks.stream().filter(e -> ExecuteState.EXECUTING.equals(e.getExecuteState())).map(SchedTask::getWorker).anyMatch(this::isAliveWorker);
    }

    public boolean isAliveWorker(String text) {
        return StringUtils.isNotBlank((CharSequence)text) && this.isAliveWorker(Worker.deserialize((String)text));
    }

    public boolean isDeadWorker(String text) {
        return !this.isAliveWorker(text);
    }

    public boolean isAliveWorker(Worker worker) {
        return worker != null && this.workerDiscover.isDiscoveredServer((Server)worker);
    }

    public boolean isDeadWorker(Worker worker) {
        return !this.isAliveWorker(worker);
    }

    public boolean hasNotDiscoveredWorkers(String group) {
        return CollectionUtils.isEmpty((Collection)this.workerDiscover.getDiscoveredServers(group));
    }

    public boolean hasNotDiscoveredWorkers() {
        return !this.workerDiscover.hasDiscoveredServers();
    }

    public boolean dispatch(SchedJob job, SchedInstance instance, List<SchedTask> tasks) {
        List<Object> list;
        String supervisorToken = SchedGroupService.createSupervisorAuthenticationToken(job.getGroup());
        ExecuteTaskParam.Builder builder = ExecuteTaskParam.builder((SchedInstance)instance, (SchedJob)job, (String)supervisorToken);
        if (RouteStrategy.BROADCAST.equals(job.getRouteStrategy())) {
            list = new ArrayList(tasks.size());
            for (SchedTask task : tasks) {
                Assert.hasText((String)task.getWorker(), () -> "Broadcast route strategy worker must pre assign: " + task.getTaskId());
                Worker worker = Worker.deserialize((String)task.getWorker());
                if (this.isDeadWorker(worker)) {
                    this.cancelWaitingTask(task.getTaskId());
                    continue;
                }
                list.add(builder.build(Operation.TRIGGER, task.getTaskId().longValue(), instance.getTriggerTime().longValue(), worker));
            }
        } else {
            list = tasks.stream().map(e -> builder.build(Operation.TRIGGER, e.getTaskId().longValue(), instance.getTriggerTime().longValue(), null)).collect(Collectors.toList());
        }
        return this.taskDispatcher.dispatch(list, job.getGroup());
    }

    public boolean dispatch(List<ExecuteTaskParam> params) {
        ArrayList<ExecuteTaskParam> list = new ArrayList<ExecuteTaskParam>(params.size());
        for (ExecuteTaskParam param : params) {
            if (RouteStrategy.BROADCAST == param.getRouteStrategy() && this.isDeadWorker(param.getWorker())) {
                this.cancelWaitingTask(param.getTaskId());
                continue;
            }
            list.add(param);
        }
        return this.taskDispatcher.dispatch(list);
    }

    protected abstract boolean cancelWaitingTask(long var1);

    private void verifyJob(SchedJob job) throws JobException {
        JobHandlerParam param = JobHandlerParam.from((SchedJob)job);
        SchedGroupService.fillSupervisorAuthenticationToken(job.getGroup(), (AuthenticationParam)param);
        this.workerRpcServiceClient.invokeWithoutResult(job.getGroup(), client -> client.verify(param));
    }

    private List<SplitTask> splitJob(JobHandlerParam param) throws JobException {
        SchedGroupService.fillSupervisorAuthenticationToken(param.getGroup(), (AuthenticationParam)param);
        return (List)this.workerRpcServiceClient.invoke(param.getGroup(), client -> client.split(param));
    }

    private void parseTriggerConfig(SchedJob job) {
        TriggerType triggerType = TriggerType.of((Integer)job.getTriggerType());
        Long jobId = job.getJobId();
        if (triggerType == TriggerType.DEPEND) {
            List parentJobIds = SchedDepend.parseTriggerValue((String)job.getTriggerValue());
            Assert.notEmpty((Collection)parentJobIds, () -> "Invalid dependency parent job id config: " + job.getTriggerValue());
            Assert.isTrue((!parentJobIds.contains(jobId) ? 1 : 0) != 0, () -> "Cannot depends self: " + jobId + ", " + parentJobIds);
            Map parentJobMap = this.jobMapper.findByJobIds(parentJobIds).stream().collect(Collectors.toMap(SchedJob::getJobId, Function.identity()));
            for (Long parentJobId : parentJobIds) {
                SchedJob parentJob = (SchedJob)parentJobMap.get(parentJobId);
                Assert.notNull((Object)parentJob, () -> "Parent job id not found: " + parentJobId);
                if (job.getGroup().equals(parentJob.getGroup())) continue;
                throw new IllegalArgumentException("Invalid group: parent=" + parentJob.getGroup() + ", child=" + job.getGroup());
            }
            this.checkCircularDepends(jobId, new HashSet<Long>(parentJobIds));
            ArrayList<SchedDepend> list = new ArrayList<SchedDepend>(parentJobIds.size());
            for (int i = 0; i < parentJobIds.size(); ++i) {
                list.add(new SchedDepend((Long)parentJobIds.get(i), jobId, Integer.valueOf(i + 1)));
            }
            this.dependMapper.batchInsert(list);
            job.setTriggerValue(Joiner.on((String)",").join((Iterable)parentJobIds));
            job.setNextTriggerTime(null);
        } else {
            Date nextTriggerTime;
            if (TriggerType.Const.FIXED_TYPES.contains(triggerType)) {
                nextTriggerTime = Dates.max((Date)new Date(), (Date)job.getStartTime());
            } else {
                Date baseTime = Dates.max((Date)new Date(), (Date)job.getStartTime());
                nextTriggerTime = triggerType.computeNextTriggerTime(job.getTriggerValue(), baseTime);
            }
            if (nextTriggerTime == null) {
                throw new IllegalArgumentException("Not next trigger time: " + job.getTriggerType() + ", " + job.getTriggerValue());
            }
            if (job.getEndTime() != null && nextTriggerTime.after(job.getEndTime())) {
                throw new IllegalArgumentException("Expire next trigger time: " + job.getTriggerType() + ", " + job.getTriggerValue());
            }
            job.setNextTriggerTime(Long.valueOf(nextTriggerTime.getTime()));
        }
    }

    private void checkCircularDepends(Long jobId, Set<Long> parentJobIds) {
        Set<Long> outerDepends = parentJobIds;
        int i = 1;
        Map map;
        while (!MapUtils.isEmpty(map = this.dependMapper.findByChildJobIds(parentJobIds).stream().collect(Collectors.toMap(SchedDepend::getParentJobId, Function.identity(), (v1, v2) -> v1)))) {
            if (map.containsKey(jobId)) {
                throw new IllegalArgumentException("Circular depends job: " + map.get(jobId));
            }
            if (i >= 20) {
                throw new IllegalArgumentException("Too many depends level: " + outerDepends);
            }
            parentJobIds = map.keySet();
            ++i;
        }
        return;
    }

    public AbstractJobManager(SchedJobMapper jobMapper, SchedDependMapper dependMapper, IdGenerator idGenerator, SupervisorRegistry workerDiscover, TaskDispatcher taskDispatcher, DiscoveryServerRestProxy.GroupedServerInvoker<WorkerRpcService> workerRpcServiceClient) {
        this.jobMapper = jobMapper;
        this.dependMapper = dependMapper;
        this.idGenerator = idGenerator;
        this.workerDiscover = workerDiscover;
        this.taskDispatcher = taskDispatcher;
        this.workerRpcServiceClient = workerRpcServiceClient;
    }
}

