/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.provider;

import cn.ponfee.disjob.common.model.PageResponse;
import cn.ponfee.disjob.common.model.Result;
import cn.ponfee.disjob.common.spring.BaseController;
import cn.ponfee.disjob.core.exception.JobException;
import cn.ponfee.disjob.supervisor.application.AuthorizeGroupService;
import cn.ponfee.disjob.supervisor.application.OpenapiService;
import cn.ponfee.disjob.supervisor.application.request.SchedInstancePageRequest;
import cn.ponfee.disjob.supervisor.application.request.SchedJobAddRequest;
import cn.ponfee.disjob.supervisor.application.request.SchedJobPageRequest;
import cn.ponfee.disjob.supervisor.application.request.SchedJobUpdateRequest;
import cn.ponfee.disjob.supervisor.application.response.SchedInstanceResponse;
import cn.ponfee.disjob.supervisor.application.response.SchedJobResponse;
import cn.ponfee.disjob.supervisor.application.response.SchedTaskResponse;
import cn.ponfee.disjob.supervisor.auth.AuthenticationConfigurer;
import cn.ponfee.disjob.supervisor.auth.SupervisorAuthentication;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Supervisor openapi provider")
@RestController
@RequestMapping(value={"/supervisor/openapi"})
@SupervisorAuthentication(value=SupervisorAuthentication.Subject.USER)
public class SupervisorOpenapiProvider
extends BaseController {
    private final OpenapiService openapiService;
    private final AuthorizeGroupService authorizeGroupService;

    public SupervisorOpenapiProvider(OpenapiService openapiService, AuthorizeGroupService authorizeGroupService) {
        this.openapiService = openapiService;
        this.authorizeGroupService = authorizeGroupService;
    }

    @PostMapping(value={"/job/add"})
    public Result<Long> addJob(@RequestBody SchedJobAddRequest req) throws JobException {
        AuthorizeGroupService.authorizeGroup(AuthenticationConfigurer.requestUser(), AuthenticationConfigurer.requestGroup(), req.getGroup());
        return Result.success((Object)this.openapiService.addJob(req));
    }

    @PutMapping(value={"/job/update"})
    public Result<Void> updateJob(@RequestBody SchedJobUpdateRequest req) throws JobException {
        AuthorizeGroupService.authorizeGroup(AuthenticationConfigurer.requestUser(), AuthenticationConfigurer.requestGroup(), req.getGroup());
        this.openapiService.updateJob(req);
        return Result.success();
    }

    @DeleteMapping(value={"/job/delete"})
    public Result<Void> deleteJob(@RequestParam(value="jobId") long jobId) {
        this.authorizeGroupService.authorizeJob(AuthenticationConfigurer.requestUser(), AuthenticationConfigurer.requestGroup(), jobId);
        this.openapiService.deleteJob(jobId);
        return Result.success();
    }

    @PostMapping(value={"/job/state/change"})
    public Result<Boolean> changeJobState(@RequestParam(value="jobId") long jobId, @RequestParam(value="jobState") int jobState) {
        this.authorizeGroupService.authorizeJob(AuthenticationConfigurer.requestUser(), AuthenticationConfigurer.requestGroup(), jobId);
        return Result.success((Object)this.openapiService.changeJobState(jobId, jobState));
    }

    @PostMapping(value={"/job/trigger"})
    public Result<Void> triggerJob(@RequestParam(value="jobId") long jobId) throws JobException {
        this.authorizeGroupService.authorizeJob(AuthenticationConfigurer.requestUser(), AuthenticationConfigurer.requestGroup(), jobId);
        this.openapiService.triggerJob(jobId);
        return Result.success();
    }

    @GetMapping(value={"/job/get"})
    public Result<SchedJobResponse> getJob(@RequestParam(value="jobId") long jobId) {
        this.authorizeGroupService.authorizeJob(AuthenticationConfigurer.requestUser(), AuthenticationConfigurer.requestGroup(), jobId);
        return Result.success((Object)this.openapiService.getJob(jobId));
    }

    @GetMapping(value={"/job/page"})
    public Result<PageResponse<SchedJobResponse>> queryJobForPage(SchedJobPageRequest pageRequest) {
        pageRequest.authorizeAndTruncateGroup(AuthenticationConfigurer.requestUser());
        return Result.success(this.openapiService.queryJobForPage(pageRequest));
    }

    @PostMapping(value={"/instance/pause"})
    public Result<Void> pauseInstance(@RequestParam(value="instanceId") long instanceId) {
        this.authorizeGroupService.authorizeInstance(AuthenticationConfigurer.requestUser(), AuthenticationConfigurer.requestGroup(), instanceId);
        this.openapiService.pauseInstance(instanceId);
        return Result.success();
    }

    @PostMapping(value={"/instance/cancel"})
    public Result<Void> cancelInstance(@RequestParam(value="instanceId") long instanceId) {
        this.authorizeGroupService.authorizeInstance(AuthenticationConfigurer.requestUser(), AuthenticationConfigurer.requestGroup(), instanceId);
        this.openapiService.cancelInstance(instanceId);
        return Result.success();
    }

    @PostMapping(value={"/instance/resume"})
    public Result<Void> resumeInstance(@RequestParam(value="instanceId") long instanceId) {
        this.authorizeGroupService.authorizeInstance(AuthenticationConfigurer.requestUser(), AuthenticationConfigurer.requestGroup(), instanceId);
        this.openapiService.resumeInstance(instanceId);
        return Result.success();
    }

    @DeleteMapping(value={"/instance/delete"})
    public Result<Void> deleteInstance(@RequestParam(value="instanceId") long instanceId) {
        this.authorizeGroupService.authorizeInstance(AuthenticationConfigurer.requestUser(), AuthenticationConfigurer.requestGroup(), instanceId);
        this.openapiService.deleteInstance(instanceId);
        return Result.success();
    }

    @PostMapping(value={"/instance/state/change"})
    public Result<Void> changeInstanceState(@RequestParam(value="instanceId") long instanceId, @RequestParam(value="targetExecuteState") int targetExecuteState) {
        this.authorizeGroupService.authorizeInstance(AuthenticationConfigurer.requestUser(), AuthenticationConfigurer.requestGroup(), instanceId);
        this.openapiService.changeInstanceState(instanceId, targetExecuteState);
        return Result.success();
    }

    @GetMapping(value={"/instance/get"})
    public Result<SchedInstanceResponse> getInstance(@RequestParam(value="instanceId") long instanceId, @RequestParam(value="withTasks", defaultValue="false") boolean withTasks) {
        this.authorizeGroupService.authorizeInstance(AuthenticationConfigurer.requestUser(), AuthenticationConfigurer.requestGroup(), instanceId);
        return Result.success((Object)this.openapiService.getInstance(instanceId, withTasks));
    }

    @GetMapping(value={"/instance/tasks"})
    public Result<List<SchedTaskResponse>> getInstanceTasks(@RequestParam(value="instanceId") long instanceId) {
        this.authorizeGroupService.authorizeInstance(AuthenticationConfigurer.requestUser(), AuthenticationConfigurer.requestGroup(), instanceId);
        return Result.success(this.openapiService.getInstanceTasks(instanceId));
    }

    @GetMapping(value={"/instance/page"})
    public Result<PageResponse<SchedInstanceResponse>> queryInstanceForPage(SchedInstancePageRequest pageRequest) {
        pageRequest.authorize(AuthenticationConfigurer.requestUser(), this.authorizeGroupService);
        return Result.success(this.openapiService.queryInstanceForPage(pageRequest));
    }

    @GetMapping(value={"/instance/children"})
    public Result<List<SchedInstanceResponse>> listInstanceChildren(@RequestParam(value="pnstanceId") long pnstanceId) {
        this.authorizeGroupService.authorizeInstance(AuthenticationConfigurer.requestUser(), AuthenticationConfigurer.requestGroup(), pnstanceId);
        return Result.success(this.openapiService.listInstanceChildren(pnstanceId));
    }
}

