/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.util;

import cn.ponfee.disjob.common.date.Dates;
import cn.ponfee.disjob.core.enums.MisfireStrategy;
import cn.ponfee.disjob.core.enums.TriggerType;
import cn.ponfee.disjob.core.model.SchedJob;
import java.util.Date;

public final class TriggerTimeUtils {
    public static Long computeNextTriggerTime(SchedJob job, Date now) {
        Date next;
        TriggerType triggerType;
        if (job == null || TriggerType.DEPEND == (triggerType = TriggerType.of((Integer)job.getTriggerType()))) {
            return null;
        }
        MisfireStrategy misfireStrategy = MisfireStrategy.of((Integer)job.getMisfireStrategy());
        Date last = Dates.ofTimeMillis((Long)job.getLastTriggerTime());
        Date base = Dates.max((Date)job.getStartTime(), (Date)last, (Date)now);
        if (triggerType == TriggerType.ONCE) {
            next = last != null ? null : (misfireStrategy == MisfireStrategy.DISCARD ? triggerType.computeNextTriggerTime(job.getTriggerValue(), base) : triggerType.computeNextTriggerTime(job.getTriggerValue(), new Date(Long.MIN_VALUE)));
        } else if (misfireStrategy == MisfireStrategy.DISCARD || last == null) {
            next = triggerType.computeNextTriggerTime(job.getTriggerValue(), base);
        } else if (misfireStrategy == MisfireStrategy.LAST) {
            last = job.getStartTime() != null && job.getStartTime().after(last) ? job.getStartTime() : triggerType.computeNextTriggerTime(job.getTriggerValue(), last);
            do {
                next = last;
            } while ((last = triggerType.computeNextTriggerTime(job.getTriggerValue(), last)) != null && last.before(base));
        } else if (misfireStrategy == MisfireStrategy.EVERY) {
            next = triggerType.computeNextTriggerTime(job.getTriggerValue(), Dates.max((Date)last, (Date)job.getStartTime()));
        } else {
            throw new IllegalArgumentException("Unsupported misfire strategy: " + job.getMisfireStrategy());
        }
        return next == null || job.getEndTime() != null && next.after(job.getEndTime()) ? null : Long.valueOf(next.getTime());
    }
}

