/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor;

import cn.ponfee.disjob.common.base.Startable;
import cn.ponfee.disjob.common.exception.Throwables;
import cn.ponfee.disjob.common.lock.DoInLocked;
import cn.ponfee.disjob.core.base.Server;
import cn.ponfee.disjob.core.base.Supervisor;
import cn.ponfee.disjob.dispatch.TaskDispatcher;
import cn.ponfee.disjob.registry.SupervisorRegistry;
import cn.ponfee.disjob.supervisor.component.DistributedJobManager;
import cn.ponfee.disjob.supervisor.component.DistributedJobQuerier;
import cn.ponfee.disjob.supervisor.configuration.SupervisorProperties;
import cn.ponfee.disjob.supervisor.thread.RunningInstanceScanner;
import cn.ponfee.disjob.supervisor.thread.TriggeringJobScanner;
import cn.ponfee.disjob.supervisor.thread.WaitingInstanceScanner;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupervisorStartup
implements Startable {
    private static final Logger LOG = LoggerFactory.getLogger(SupervisorStartup.class);
    private final Supervisor.Current currentSupervisor;
    private final TriggeringJobScanner triggeringJobScanner;
    private final WaitingInstanceScanner waitingInstanceScanner;
    private final RunningInstanceScanner runningInstanceScanner;
    private final TaskDispatcher taskDispatcher;
    private final SupervisorRegistry supervisorRegistry;
    private final AtomicBoolean started = new AtomicBoolean(false);

    private SupervisorStartup(Supervisor.Current currentSupervisor, SupervisorProperties supervisorProperties, SupervisorRegistry supervisorRegistry, DistributedJobManager distributedJobManager, DistributedJobQuerier distributedJobQuerier, DoInLocked scanTriggeringJobLocker, DoInLocked scanWaitingInstanceLocker, DoInLocked scanRunningInstanceLocker, TaskDispatcher taskDispatcher) {
        Objects.requireNonNull(currentSupervisor, "Current supervisor cannot null.");
        Objects.requireNonNull(supervisorProperties, "Supervisor properties cannot null.").check();
        Objects.requireNonNull(supervisorRegistry, "Supervisor registry cannot null.");
        Objects.requireNonNull(distributedJobManager, "Distributed job manager cannot null.");
        Objects.requireNonNull(scanTriggeringJobLocker, "Scan triggering job locker cannot null.");
        Objects.requireNonNull(scanWaitingInstanceLocker, "Scan waiting instance locker cannot null.");
        Objects.requireNonNull(scanRunningInstanceLocker, "Scan running instance locker cannot null.");
        Objects.requireNonNull(taskDispatcher, "Task dispatcher cannot null.");
        this.currentSupervisor = currentSupervisor;
        this.supervisorRegistry = supervisorRegistry;
        this.triggeringJobScanner = new TriggeringJobScanner(supervisorProperties, scanTriggeringJobLocker, distributedJobManager, distributedJobQuerier);
        this.waitingInstanceScanner = new WaitingInstanceScanner(supervisorProperties.getScanWaitingInstancePeriodMs(), scanWaitingInstanceLocker, distributedJobManager, distributedJobQuerier);
        this.runningInstanceScanner = new RunningInstanceScanner(supervisorProperties.getScanRunningInstancePeriodMs(), scanRunningInstanceLocker, distributedJobManager, distributedJobQuerier);
        this.taskDispatcher = taskDispatcher;
    }

    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            LOG.warn("Supervisor startup already started.");
            return;
        }
        this.waitingInstanceScanner.start();
        this.runningInstanceScanner.start();
        this.triggeringJobScanner.start();
        this.supervisorRegistry.register((Server)this.currentSupervisor);
    }

    public void stop() {
        if (!this.started.compareAndSet(true, false)) {
            LOG.warn("Supervisor startup already Stopped.");
            return;
        }
        Throwables.ThrowingRunnable.doCaught(() -> ((SupervisorRegistry)this.supervisorRegistry).close());
        Throwables.ThrowingRunnable.doCaught(() -> ((TriggeringJobScanner)this.triggeringJobScanner).toStop());
        Throwables.ThrowingRunnable.doCaught(() -> ((RunningInstanceScanner)this.runningInstanceScanner).toStop());
        Throwables.ThrowingRunnable.doCaught(() -> ((WaitingInstanceScanner)this.waitingInstanceScanner).toStop());
        Throwables.ThrowingRunnable.doCaught(() -> ((TaskDispatcher)this.taskDispatcher).close());
        Throwables.ThrowingRunnable.doCaught(this.triggeringJobScanner::close);
        Throwables.ThrowingRunnable.doCaught(() -> ((RunningInstanceScanner)this.runningInstanceScanner).close());
        Throwables.ThrowingRunnable.doCaught(() -> ((WaitingInstanceScanner)this.waitingInstanceScanner).close());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Supervisor.Current currentSupervisor;
        private SupervisorProperties supervisorProperties;
        private SupervisorRegistry supervisorRegistry;
        private DistributedJobManager distributedJobManager;
        private DistributedJobQuerier distributedJobQuerier;
        private DoInLocked scanTriggeringJobLocker;
        private DoInLocked scanWaitingInstanceLocker;
        private DoInLocked scanRunningInstanceLocker;
        private TaskDispatcher taskDispatcher;

        private Builder() {
        }

        public Builder currentSupervisor(Supervisor.Current currentSupervisor) {
            this.currentSupervisor = currentSupervisor;
            return this;
        }

        public Builder supervisorProperties(SupervisorProperties supervisorProperties) {
            this.supervisorProperties = supervisorProperties;
            return this;
        }

        public Builder supervisorRegistry(SupervisorRegistry supervisorRegistry) {
            this.supervisorRegistry = supervisorRegistry;
            return this;
        }

        public Builder distributedJobManager(DistributedJobManager distributedJobManager) {
            this.distributedJobManager = distributedJobManager;
            return this;
        }

        public Builder distributedJobQuerier(DistributedJobQuerier distributedJobQuerier) {
            this.distributedJobQuerier = distributedJobQuerier;
            return this;
        }

        public Builder scanTriggeringJobLocker(DoInLocked scanTriggeringJobLocker) {
            this.scanTriggeringJobLocker = scanTriggeringJobLocker;
            return this;
        }

        public Builder scanWaitingInstanceLocker(DoInLocked scanWaitingInstanceLocker) {
            this.scanWaitingInstanceLocker = scanWaitingInstanceLocker;
            return this;
        }

        public Builder scanRunningInstanceLocker(DoInLocked scanRunningInstanceLocker) {
            this.scanRunningInstanceLocker = scanRunningInstanceLocker;
            return this;
        }

        public Builder taskDispatcher(TaskDispatcher taskDispatcher) {
            this.taskDispatcher = taskDispatcher;
            return this;
        }

        public SupervisorStartup build() {
            return new SupervisorStartup(this.currentSupervisor, this.supervisorProperties, this.supervisorRegistry, this.distributedJobManager, this.distributedJobQuerier, this.scanTriggeringJobLocker, this.scanWaitingInstanceLocker, this.scanRunningInstanceLocker, this.taskDispatcher);
        }
    }
}

