/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.application;

import cn.ponfee.disjob.common.base.SingletonClassConstraint;
import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.concurrent.ThreadPoolExecutors;
import cn.ponfee.disjob.common.exception.Throwables;
import cn.ponfee.disjob.core.exception.AuthenticationException;
import cn.ponfee.disjob.core.exception.KeyNotExistsException;
import cn.ponfee.disjob.supervisor.application.SchedGroupService;
import cn.ponfee.disjob.supervisor.dao.mapper.SchedInstanceMapper;
import cn.ponfee.disjob.supervisor.dao.mapper.SchedJobMapper;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Sets;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AuthorizeGroupService
extends SingletonClassConstraint {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizeGroupService.class);
    public static final int SQL_GROUP_IN_MAX_SIZE = 50;
    private final SchedJobMapper schedJobMapper;
    private final SchedInstanceMapper schedInstanceMapper;
    private final Cache<Long, String> jobGroupCache = CacheBuilder.newBuilder().initialCapacity(1000).maximumSize(1000000L).expireAfterAccess(Duration.ofDays(1L)).build();

    public AuthorizeGroupService(SchedJobMapper schedJobMapper, SchedInstanceMapper schedInstanceMapper) {
        this.schedJobMapper = schedJobMapper;
        this.schedInstanceMapper = schedInstanceMapper;
        ThreadPoolExecutors.commonScheduledPool().scheduleWithFixedDelay(Throwables.ThrowingRunnable.toCaught(() -> this.jobGroupCache.cleanUp()), 2L, 2L, TimeUnit.DAYS);
    }

    public static Set<String> authorizeAndTruncateGroup(String user, Set<String> paramGroups) {
        Set<String> permitGroups = SchedGroupService.myGroups(user);
        if (CollectionUtils.isEmpty(paramGroups)) {
            paramGroups = permitGroups;
        } else if (!permitGroups.containsAll(paramGroups)) {
            throw new AuthenticationException("Unauthorized group: " + Sets.difference(paramGroups, permitGroups));
        }
        return AuthorizeGroupService.truncateGroup(paramGroups);
    }

    public static Set<String> truncateGroup(Set<String> paramGroups) {
        return Collects.truncate(paramGroups, (int)50);
    }

    public static void authorizeGroup(String user, String dataGroup) {
        if (!SchedGroupService.myGroups(user).contains(dataGroup)) {
            throw new AuthenticationException("Unauthorized group: " + dataGroup);
        }
    }

    public static void authorizeGroup(String user, String authGroup, String dataGroup) {
        if (!authGroup.equals(dataGroup)) {
            throw new AuthenticationException("Unmatched group: " + authGroup + " != " + dataGroup);
        }
        AuthorizeGroupService.authorizeGroup(user, dataGroup);
    }

    public void authorizeJob(String user, long jobId) {
        String dataGroup = this.getJobGroup(jobId);
        if (StringUtils.isEmpty((CharSequence)dataGroup)) {
            throw new KeyNotExistsException("Job id not exists: " + jobId);
        }
        AuthorizeGroupService.authorizeGroup(user, dataGroup);
    }

    public void authorizeJob(String user, String authGroup, long jobId) {
        String dataGroup = this.getJobGroup(jobId);
        if (StringUtils.isEmpty((CharSequence)dataGroup)) {
            throw new KeyNotExistsException("Job id not exists: " + jobId);
        }
        AuthorizeGroupService.authorizeGroup(user, authGroup, dataGroup);
    }

    public void authorizeInstance(String user, long instanceId) {
        Long jobId = this.schedInstanceMapper.getJobId(instanceId);
        if (jobId == null) {
            throw new KeyNotExistsException("Instance id not exists: " + instanceId);
        }
        this.authorizeJob(user, jobId);
    }

    public void authorizeInstance(String user, String authGroup, long instanceId) {
        Long jobId = this.schedInstanceMapper.getJobId(instanceId);
        if (jobId == null) {
            throw new KeyNotExistsException("Instance id not exists: " + instanceId);
        }
        this.authorizeJob(user, authGroup, jobId);
    }

    private String getJobGroup(Long jobId) {
        String group = (String)this.jobGroupCache.getIfPresent((Object)jobId);
        if (group != null) {
            return group;
        }
        group = this.schedJobMapper.getGroup(jobId);
        if (group != null) {
            LOG.info("Loaded caching group: {}, {}", (Object)jobId, (Object)group);
            this.jobGroupCache.put((Object)jobId, (Object)group);
        } else {
            LOG.warn("Loading job not exists: {}", (Object)jobId);
        }
        return group;
    }
}

