/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.application;

import cn.ponfee.disjob.common.base.SingletonClassConstraint;
import cn.ponfee.disjob.common.model.CodeMsg;
import cn.ponfee.disjob.common.model.PageResponse;
import cn.ponfee.disjob.core.base.JobCodeMsg;
import cn.ponfee.disjob.core.enums.ExecuteState;
import cn.ponfee.disjob.core.enums.JobState;
import cn.ponfee.disjob.core.enums.Operation;
import cn.ponfee.disjob.core.exception.JobException;
import cn.ponfee.disjob.core.exception.JobRuntimeException;
import cn.ponfee.disjob.core.model.SchedInstance;
import cn.ponfee.disjob.core.model.SchedJob;
import cn.ponfee.disjob.core.model.SchedTask;
import cn.ponfee.disjob.supervisor.application.SchedGroupService;
import cn.ponfee.disjob.supervisor.application.converter.SchedJobConverter;
import cn.ponfee.disjob.supervisor.application.request.SchedInstancePageRequest;
import cn.ponfee.disjob.supervisor.application.request.SchedJobAddRequest;
import cn.ponfee.disjob.supervisor.application.request.SchedJobPageRequest;
import cn.ponfee.disjob.supervisor.application.request.SchedJobUpdateRequest;
import cn.ponfee.disjob.supervisor.application.response.SchedInstanceResponse;
import cn.ponfee.disjob.supervisor.application.response.SchedJobResponse;
import cn.ponfee.disjob.supervisor.application.response.SchedTaskResponse;
import cn.ponfee.disjob.supervisor.component.DistributedJobManager;
import cn.ponfee.disjob.supervisor.component.DistributedJobQuerier;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class OpenapiService
extends SingletonClassConstraint {
    private static final Logger LOG = LoggerFactory.getLogger(OpenapiService.class);
    private final DistributedJobManager jobManager;
    private final DistributedJobQuerier jobQuerier;

    public OpenapiService(DistributedJobManager jobManager, DistributedJobQuerier jobQuerier) {
        this.jobManager = jobManager;
        this.jobQuerier = jobQuerier;
    }

    public Long addJob(SchedJobAddRequest req) throws JobException {
        String user = req.getCreatedBy();
        String group = req.getGroup();
        Set<String> groups = SchedGroupService.myGroups(user);
        Assert.isTrue((boolean)groups.contains(group), (String)("User '" + user + "' not has group '" + group + "' permission."));
        return this.jobManager.addJob(req.tosSchedJob());
    }

    public void updateJob(SchedJobUpdateRequest req) throws JobException {
        LOG.info("Do updating sched job {}", (Object)req.getJobId());
        this.jobManager.updateJob(req.tosSchedJob());
    }

    public void deleteJob(long jobId) {
        LOG.info("Do deleting sched job {}", (Object)jobId);
        this.jobManager.deleteJob(jobId);
    }

    public Boolean changeJobState(long jobId, int jobState) {
        LOG.info("Do change sched job state {}", (Object)jobId);
        return this.jobManager.changeJobState(jobId, JobState.of((Integer)jobState));
    }

    public void triggerJob(long jobId) throws JobException {
        LOG.info("Do manual trigger the sched job {}", (Object)jobId);
        this.jobManager.triggerJob(jobId);
    }

    public SchedJobResponse getJob(long jobId) {
        SchedJob schedJob = this.jobQuerier.getJob(jobId);
        return SchedJobConverter.INSTANCE.convert(schedJob);
    }

    public PageResponse<SchedJobResponse> queryJobForPage(SchedJobPageRequest pageRequest) {
        return this.jobQuerier.queryJobForPage(pageRequest);
    }

    public void pauseInstance(long instanceId) {
        LOG.info("Do pausing sched instance {}", (Object)instanceId);
        if (!this.jobManager.pauseInstance(instanceId)) {
            throw new JobRuntimeException((CodeMsg)JobCodeMsg.NOT_PAUSABLE_INSTANCE);
        }
    }

    public void cancelInstance(long instanceId) {
        LOG.info("Do canceling sched instance {}", (Object)instanceId);
        if (!this.jobManager.cancelInstance(instanceId, Operation.MANUAL_CANCEL)) {
            throw new JobRuntimeException((CodeMsg)JobCodeMsg.NOT_CANCELABLE_INSTANCE);
        }
    }

    public void resumeInstance(long instanceId) {
        LOG.info("Do resuming sched instance {}", (Object)instanceId);
        if (!this.jobManager.resumeInstance(instanceId)) {
            throw new JobRuntimeException((CodeMsg)JobCodeMsg.NOT_RESUMABLE_INSTANCE);
        }
    }

    public void changeInstanceState(long instanceId, int targetExecuteState) {
        ExecuteState.of((Integer)targetExecuteState);
        LOG.info("Do force change state {}, {}", (Object)instanceId, (Object)targetExecuteState);
        this.jobManager.changeInstanceState(instanceId, ExecuteState.of((Integer)targetExecuteState));
    }

    public void deleteInstance(long instanceId) {
        LOG.info("Do deleting sched instance {}", (Object)instanceId);
        this.jobManager.deleteInstance(instanceId);
    }

    public SchedInstanceResponse getInstance(long instanceId, boolean withTasks) {
        SchedInstance instance = this.jobQuerier.getInstance(instanceId);
        if (instance == null) {
            return null;
        }
        List<SchedTask> tasks = null;
        if (withTasks) {
            tasks = this.jobQuerier.findLargeInstanceTasks(instanceId);
        }
        return SchedInstanceResponse.of(instance, tasks);
    }

    public List<SchedTaskResponse> getInstanceTasks(long instanceId) {
        List<SchedTask> tasks = this.jobQuerier.findLargeInstanceTasks(instanceId);
        if (tasks == null) {
            return null;
        }
        return tasks.stream().map(SchedJobConverter.INSTANCE::convert).collect(Collectors.toList());
    }

    public PageResponse<SchedInstanceResponse> queryInstanceForPage(SchedInstancePageRequest pageRequest) {
        return this.jobQuerier.queryInstanceForPage(pageRequest);
    }

    public List<SchedInstanceResponse> listInstanceChildren(long pnstanceId) {
        return this.jobQuerier.listInstanceChildren(pnstanceId);
    }
}

