/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.application.converter;

import cn.ponfee.disjob.core.base.SupervisorMetrics;
import cn.ponfee.disjob.core.base.WorkerMetrics;
import cn.ponfee.disjob.supervisor.application.converter.CommonMapper;
import cn.ponfee.disjob.supervisor.application.converter.ServerMetricsConverter;
import cn.ponfee.disjob.supervisor.application.response.SupervisorMetricsResponse;
import cn.ponfee.disjob.supervisor.application.response.WorkerMetricsResponse;

public class ServerMetricsConverterImpl
implements ServerMetricsConverter {
    @Override
    public SupervisorMetricsResponse convert(SupervisorMetrics source) {
        if (source == null) {
            return null;
        }
        SupervisorMetricsResponse supervisorMetricsResponse = new SupervisorMetricsResponse();
        supervisorMetricsResponse.setVersion(source.getVersion());
        supervisorMetricsResponse.setStartupAt(CommonMapper.asString(source.getStartupAt()));
        supervisorMetricsResponse.setAlsoWorker(source.isAlsoWorker());
        return supervisorMetricsResponse;
    }

    @Override
    public WorkerMetricsResponse convert(WorkerMetrics source) {
        if (source == null) {
            return null;
        }
        WorkerMetricsResponse workerMetricsResponse = new WorkerMetricsResponse();
        workerMetricsResponse.setClosed(this.sourceThreadPoolClosed(source));
        workerMetricsResponse.setKeepAliveTime(this.sourceThreadPoolKeepAliveTime(source));
        workerMetricsResponse.setMaximumPoolSize(this.sourceThreadPoolMaximumPoolSize(source));
        workerMetricsResponse.setCurrentPoolSize(this.sourceThreadPoolCurrentPoolSize(source));
        workerMetricsResponse.setActivePoolSize(this.sourceThreadPoolActivePoolSize(source));
        workerMetricsResponse.setIdlePoolSize(this.sourceThreadPoolIdlePoolSize(source));
        workerMetricsResponse.setQueueTaskCount(this.sourceThreadPoolQueueTaskCount(source));
        workerMetricsResponse.setCompletedTaskCount(this.sourceThreadPoolCompletedTaskCount(source));
        workerMetricsResponse.setVersion(source.getVersion());
        workerMetricsResponse.setStartupAt(CommonMapper.asString(source.getStartupAt()));
        workerMetricsResponse.setWorkerId(source.getWorkerId());
        workerMetricsResponse.setAlsoSupervisor(source.isAlsoSupervisor());
        workerMetricsResponse.setJvmThreadActiveCount(source.getJvmThreadActiveCount());
        return workerMetricsResponse;
    }

    private Boolean sourceThreadPoolClosed(WorkerMetrics workerMetrics) {
        if (workerMetrics == null) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if (threadPool == null) {
            return null;
        }
        boolean closed = threadPool.isClosed();
        return closed;
    }

    private Long sourceThreadPoolKeepAliveTime(WorkerMetrics workerMetrics) {
        if (workerMetrics == null) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if (threadPool == null) {
            return null;
        }
        long keepAliveTime = threadPool.getKeepAliveTime();
        return keepAliveTime;
    }

    private Integer sourceThreadPoolMaximumPoolSize(WorkerMetrics workerMetrics) {
        if (workerMetrics == null) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if (threadPool == null) {
            return null;
        }
        int maximumPoolSize = threadPool.getMaximumPoolSize();
        return maximumPoolSize;
    }

    private Integer sourceThreadPoolCurrentPoolSize(WorkerMetrics workerMetrics) {
        if (workerMetrics == null) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if (threadPool == null) {
            return null;
        }
        int currentPoolSize = threadPool.getCurrentPoolSize();
        return currentPoolSize;
    }

    private Integer sourceThreadPoolActivePoolSize(WorkerMetrics workerMetrics) {
        if (workerMetrics == null) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if (threadPool == null) {
            return null;
        }
        int activePoolSize = threadPool.getActivePoolSize();
        return activePoolSize;
    }

    private Integer sourceThreadPoolIdlePoolSize(WorkerMetrics workerMetrics) {
        if (workerMetrics == null) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if (threadPool == null) {
            return null;
        }
        int idlePoolSize = threadPool.getIdlePoolSize();
        return idlePoolSize;
    }

    private Long sourceThreadPoolQueueTaskCount(WorkerMetrics workerMetrics) {
        if (workerMetrics == null) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if (threadPool == null) {
            return null;
        }
        long queueTaskCount = threadPool.getQueueTaskCount();
        return queueTaskCount;
    }

    private Long sourceThreadPoolCompletedTaskCount(WorkerMetrics workerMetrics) {
        if (workerMetrics == null) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if (threadPool == null) {
            return null;
        }
        long completedTaskCount = threadPool.getCompletedTaskCount();
        return completedTaskCount;
    }
}

