/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.application.response;

import cn.ponfee.disjob.common.base.ToJsonString;
import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.core.model.SchedInstance;
import cn.ponfee.disjob.core.model.SchedTask;
import cn.ponfee.disjob.supervisor.application.converter.SchedJobConverter;
import cn.ponfee.disjob.supervisor.application.response.SchedTaskResponse;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class SchedInstanceResponse
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = -6772222626245934369L;
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private Long instanceId;
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private Long rnstanceId;
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private Long pnstanceId;
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private Long wnstanceId;
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    private Long jobId;
    private Long triggerTime;
    private Integer runType;
    private Integer runState;
    private Date runStartTime;
    private Date runEndTime;
    private Long runDuration;
    private Integer retriedCount;
    private String attach;
    private Integer isTreeLeaf;
    private List<SchedTaskResponse> tasks;

    public static SchedInstanceResponse of(SchedInstance instance, List<SchedTask> tasks) {
        if (instance == null) {
            return null;
        }
        SchedInstanceResponse instanceResponse = SchedJobConverter.INSTANCE.convert(instance);
        instanceResponse.setTasks(Collects.convert(tasks, SchedJobConverter.INSTANCE::convert));
        return instanceResponse;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public Long getRnstanceId() {
        return this.rnstanceId;
    }

    public Long getPnstanceId() {
        return this.pnstanceId;
    }

    public Long getWnstanceId() {
        return this.wnstanceId;
    }

    public Long getJobId() {
        return this.jobId;
    }

    public Long getTriggerTime() {
        return this.triggerTime;
    }

    public Integer getRunType() {
        return this.runType;
    }

    public Integer getRunState() {
        return this.runState;
    }

    public Date getRunStartTime() {
        return this.runStartTime;
    }

    public Date getRunEndTime() {
        return this.runEndTime;
    }

    public Long getRunDuration() {
        return this.runDuration;
    }

    public Integer getRetriedCount() {
        return this.retriedCount;
    }

    public String getAttach() {
        return this.attach;
    }

    public Integer getIsTreeLeaf() {
        return this.isTreeLeaf;
    }

    public List<SchedTaskResponse> getTasks() {
        return this.tasks;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING)
    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING)
    public void setRnstanceId(Long rnstanceId) {
        this.rnstanceId = rnstanceId;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING)
    public void setPnstanceId(Long pnstanceId) {
        this.pnstanceId = pnstanceId;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING)
    public void setWnstanceId(Long wnstanceId) {
        this.wnstanceId = wnstanceId;
    }

    @JsonFormat(shape=JsonFormat.Shape.STRING)
    public void setJobId(Long jobId) {
        this.jobId = jobId;
    }

    public void setTriggerTime(Long triggerTime) {
        this.triggerTime = triggerTime;
    }

    public void setRunType(Integer runType) {
        this.runType = runType;
    }

    public void setRunState(Integer runState) {
        this.runState = runState;
    }

    public void setRunStartTime(Date runStartTime) {
        this.runStartTime = runStartTime;
    }

    public void setRunEndTime(Date runEndTime) {
        this.runEndTime = runEndTime;
    }

    public void setRunDuration(Long runDuration) {
        this.runDuration = runDuration;
    }

    public void setRetriedCount(Integer retriedCount) {
        this.retriedCount = retriedCount;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }

    public void setIsTreeLeaf(Integer isTreeLeaf) {
        this.isTreeLeaf = isTreeLeaf;
    }

    public void setTasks(List<SchedTaskResponse> tasks) {
        this.tasks = tasks;
    }
}

