/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.dao;

import cn.ponfee.disjob.supervisor.base.AbstractDataSourceConfig;
import javax.sql.DataSource;
import org.apache.commons.lang3.ClassUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@ConditionalOnProperty(prefix="disjob.supervisor.datasource", name={"custom"}, havingValue="false", matchIfMissing=true)
@Configuration
@MapperScan(basePackages={"cn.ponfee.disjob.supervisor.dao.mapper"}, sqlSessionTemplateRef="disjobSqlSessionTemplate")
public class SupervisorDataSourceConfig
extends AbstractDataSourceConfig {
    static final String BASE_PACKAGE = "cn.ponfee.disjob.supervisor.dao";
    private static final String DB_NAME = "disjob";
    public static final String SPRING_BEAN_NAME_DATASOURCE = "disjobDataSource";
    public static final String SPRING_BEAN_NAME_TX_MANAGER = "disjobTransactionManager";
    public static final String SPRING_BEAN_NAME_TX_TEMPLATE = "disjobTransactionTemplate";
    public static final String SPRING_BEAN_NAME_JDBC_TEMPLATE = "disjobJdbcTemplate";
    public static final String SPRING_BEAN_NAME_SQL_SESSION_FACTORY = "disjobSqlSessionFactory";
    public static final String SPRING_BEAN_NAME_SQL_SESSION_TEMPLATE = "disjobSqlSessionTemplate";

    @Override
    @Bean(name={"disjobDataSource"})
    @ConfigurationProperties(prefix="disjob.datasource")
    public DataSource dataSource() {
        return DataSourceBuilder.create().build();
    }

    @Bean(name={"disjobSqlSessionFactory"})
    public SqlSessionFactory sqlSessionFactory() throws Exception {
        return super.createSqlSessionFactory();
    }

    @Bean(name={"disjobSqlSessionTemplate"})
    public SqlSessionTemplate sqlSessionTemplate() throws Exception {
        return new SqlSessionTemplate(this.sqlSessionFactory());
    }

    @Bean(name={"disjobTransactionManager"})
    public DataSourceTransactionManager transactionManager() {
        return new DataSourceTransactionManager(this.dataSource());
    }

    @Bean(name={"disjobTransactionTemplate"})
    public TransactionTemplate transactionTemplate() {
        return new TransactionTemplate((PlatformTransactionManager)this.transactionManager());
    }

    @Bean(name={"disjobJdbcTemplate"})
    public JdbcTemplate jdbcTemplate() {
        return new JdbcTemplate(this.dataSource());
    }

    static {
        if (!BASE_PACKAGE.equals(ClassUtils.getPackageName(SupervisorDataSourceConfig.class))) {
            throw new Error("Invalid package path of " + SupervisorDataSourceConfig.class);
        }
    }
}

