/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.provider;

import cn.ponfee.disjob.common.date.Dates;
import cn.ponfee.disjob.common.spring.RpcController;
import cn.ponfee.disjob.core.base.Supervisor;
import cn.ponfee.disjob.core.base.SupervisorMetrics;
import cn.ponfee.disjob.core.base.SupervisorRpcService;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.enums.Operation;
import cn.ponfee.disjob.core.handle.execution.WorkflowPredecessorNode;
import cn.ponfee.disjob.core.model.SchedTask;
import cn.ponfee.disjob.core.param.supervisor.EventParam;
import cn.ponfee.disjob.core.param.supervisor.StartTaskParam;
import cn.ponfee.disjob.core.param.supervisor.TerminateTaskParam;
import cn.ponfee.disjob.core.param.supervisor.UpdateTaskWorkerParam;
import cn.ponfee.disjob.supervisor.application.EventSubscribeService;
import cn.ponfee.disjob.supervisor.auth.SupervisorAuthentication;
import cn.ponfee.disjob.supervisor.component.DistributedJobManager;
import cn.ponfee.disjob.supervisor.component.DistributedJobQuerier;
import java.time.LocalDateTime;
import java.util.List;

@SupervisorAuthentication(value=SupervisorAuthentication.Subject.WORKER)
public class SupervisorRpcProvider
implements SupervisorRpcService,
RpcController {
    private final DistributedJobManager jobManager;
    private final DistributedJobQuerier jobQuerier;

    public SupervisorRpcProvider(DistributedJobManager jobManager, DistributedJobQuerier jobQuerier) {
        this.jobManager = jobManager;
        this.jobQuerier = jobQuerier;
    }

    public SchedTask getTask(long taskId) {
        return this.jobQuerier.getTask(taskId);
    }

    public boolean startTask(StartTaskParam param) {
        return this.jobManager.startTask(param);
    }

    public void updateTaskWorker(List<UpdateTaskWorkerParam> list) {
        this.jobManager.updateTaskWorker(list);
    }

    public List<WorkflowPredecessorNode> findWorkflowPredecessorNodes(long wnstanceId, long instanceId) {
        return this.jobQuerier.findWorkflowPredecessorNodes(wnstanceId, instanceId);
    }

    public boolean terminateTask(TerminateTaskParam param) {
        return this.jobManager.terminateTask(param);
    }

    public boolean pauseInstance(long instanceId) {
        return this.jobManager.pauseInstance(instanceId);
    }

    public boolean cancelInstance(long instanceId, Operation operation) {
        return this.jobManager.cancelInstance(instanceId, operation);
    }

    @SupervisorAuthentication(value=SupervisorAuthentication.Subject.ANON)
    public SupervisorMetrics metrics() {
        SupervisorMetrics metrics = new SupervisorMetrics();
        metrics.setVersion("2.0.9");
        metrics.setStartupAt(Dates.toDate((LocalDateTime)Supervisor.current().getStartupAt()));
        metrics.setAlsoWorker(Worker.current() != null);
        return metrics;
    }

    @SupervisorAuthentication(value=SupervisorAuthentication.Subject.ANON)
    public void publish(EventParam param) {
        EventSubscribeService.subscribe(param);
    }

    public void savepoint(long taskId, String executeSnapshot) {
        this.jobManager.savepoint(taskId, executeSnapshot);
    }
}

