/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.thread;

import cn.ponfee.disjob.common.base.SingletonClassConstraint;
import cn.ponfee.disjob.common.concurrent.AbstractHeartbeatThread;
import cn.ponfee.disjob.common.concurrent.MultithreadExecutors;
import cn.ponfee.disjob.common.concurrent.NamedThreadFactory;
import cn.ponfee.disjob.common.concurrent.ThreadPoolExecutors;
import cn.ponfee.disjob.common.date.Dates;
import cn.ponfee.disjob.common.lock.DoInLocked;
import cn.ponfee.disjob.core.enums.CollidedStrategy;
import cn.ponfee.disjob.core.enums.JobState;
import cn.ponfee.disjob.core.enums.MisfireStrategy;
import cn.ponfee.disjob.core.enums.Operation;
import cn.ponfee.disjob.core.enums.RunState;
import cn.ponfee.disjob.core.enums.RunType;
import cn.ponfee.disjob.core.enums.TriggerType;
import cn.ponfee.disjob.core.model.SchedInstance;
import cn.ponfee.disjob.core.model.SchedJob;
import cn.ponfee.disjob.core.model.SchedTask;
import cn.ponfee.disjob.supervisor.component.DistributedJobManager;
import cn.ponfee.disjob.supervisor.component.DistributedJobQuerier;
import cn.ponfee.disjob.supervisor.configuration.SupervisorProperties;
import cn.ponfee.disjob.supervisor.instance.TriggerInstanceCreator;
import cn.ponfee.disjob.supervisor.util.TriggerTimeUtils;
import com.google.common.math.IntMath;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import javax.annotation.PreDestroy;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DuplicateKeyException;

public class TriggeringJobScanner
extends AbstractHeartbeatThread {
    private static final int SCAN_COLLIDED_INTERVAL_SECONDS = 60;
    private static final int REMARK_MAX_LENGTH = 255;
    private final DoInLocked doInLocked;
    private final int jobScanFailedCountThreshold;
    private final DistributedJobManager jobManager;
    private final DistributedJobQuerier jobQuerier;
    private final long afterMilliseconds;
    private final ExecutorService processJobExecutor;

    public TriggeringJobScanner(SupervisorProperties supervisorProperties, DoInLocked doInLocked, DistributedJobManager jobManager, DistributedJobQuerier jobQuerier) {
        super(supervisorProperties.getScanTriggeringJobPeriodMs());
        SingletonClassConstraint.constrain((Object)((Object)this));
        this.jobScanFailedCountThreshold = supervisorProperties.getJobScanFailedCountThreshold();
        this.doInLocked = doInLocked;
        this.jobManager = jobManager;
        this.jobQuerier = jobQuerier;
        this.afterMilliseconds = this.heartbeatPeriodMs * 3L;
        this.processJobExecutor = ThreadPoolExecutors.builder().corePoolSize(1).maximumPoolSize(Math.max(1, supervisorProperties.getProcessJobMaximumPoolSize())).workQueue(new SynchronousQueue()).keepAliveTimeSeconds(300L).rejectedHandler(ThreadPoolExecutors.CALLER_RUNS).threadFactory((ThreadFactory)NamedThreadFactory.builder().prefix("triggering_job_scanner").priority(Integer.valueOf(10)).uncaughtExceptionHandler(this.log).build()).build();
    }

    protected boolean heartbeat() {
        if (this.jobManager.hasNotDiscoveredWorkers()) {
            this.log.warn("Not discovered worker.");
            return true;
        }
        Boolean result = (Boolean)this.doInLocked.action(() -> {
            Date now = new Date();
            long maxNextTriggerTime = now.getTime() + this.afterMilliseconds;
            List<SchedJob> jobs = this.jobQuerier.findBeTriggeringJob(maxNextTriggerTime, 200);
            if (CollectionUtils.isEmpty(jobs)) {
                return true;
            }
            MultithreadExecutors.run(jobs, job -> this.processJob((SchedJob)job, now, maxNextTriggerTime), (Executor)this.processJobExecutor);
            return jobs.size() < 200;
        });
        return result != null && result != false;
    }

    @PreDestroy
    public void close() {
        super.close();
        ThreadPoolExecutors.shutdown((ExecutorService)this.processJobExecutor, (int)1);
    }

    private void processJob(SchedJob job, Date now, long maxNextTriggerTime) {
        try {
            if (this.jobManager.hasNotDiscoveredWorkers(job.getGroup())) {
                this.updateNextScanTime(job, now, 30);
                this.log.warn("Scan job not discovered worker: {}, {}", (Object)job.getJobId(), (Object)job.getGroup());
                return;
            }
            job.setNextTriggerTime(this.reComputeNextTriggerTime(job, now));
            if (job.getNextTriggerTime() == null) {
                String reason = "Recompute has not next trigger time";
                job.setRemark(reason);
                this.log.info("{}, {}", (Object)reason, (Object)job);
                this.jobManager.disableJob(job);
                return;
            }
            if (job.getNextTriggerTime() > maxNextTriggerTime) {
                this.jobManager.updateJobNextTriggerTime(job);
                return;
            }
            if (this.checkBlockCollidedTrigger(job, now)) {
                return;
            }
            long triggerTime = job.getNextTriggerTime();
            TriggeringJobScanner.refreshNextTriggerTime(job, triggerTime, now);
            TriggerInstanceCreator<?> creator = TriggerInstanceCreator.of(job.getJobType(), this.jobManager);
            creator.createWithSaveAndDispatch(job, RunType.SCHEDULE, triggerTime);
        }
        catch (DuplicateKeyException e) {
            if (this.jobManager.updateJobNextTriggerTime(job)) {
                this.log.info("Conflict trigger time: {}, {}", (Object)job, (Object)e.getMessage());
            } else {
                this.log.error("Conflict trigger time: {}, {}", (Object)job, (Object)e.getMessage());
            }
        }
        catch (IllegalArgumentException e) {
            this.log.error("Scan trigger job failed: " + job, (Throwable)e);
            job.setRemark(StringUtils.truncate((String)("Scan process failed: " + e.getMessage()), (int)255));
            job.setNextTriggerTime(null);
            this.jobManager.disableJob(job);
        }
        catch (Throwable t) {
            this.log.error("Scan trigger job error: " + job, t);
            if (job.getScanFailedCount() >= this.jobScanFailedCountThreshold) {
                job.setRemark(StringUtils.truncate((String)("Scan over failed: " + t.getMessage()), (int)255));
                job.setNextTriggerTime(null);
                this.jobManager.disableJob(job);
            }
            int scanFailedCount = job.incrementAndGetScanFailedCount();
            this.updateNextScanTime(job, now, IntMath.pow((int)scanFailedCount, (int)2) * 5);
        }
    }

    private Long reComputeNextTriggerTime(SchedJob job, Date now) {
        if (TriggerType.FIXED_DELAY.equalsValue(job.getTriggerType())) {
            return job.obtainNextTriggerTime();
        }
        if (now.getTime() <= job.getNextTriggerTime() + this.afterMilliseconds) {
            return job.getNextTriggerTime();
        }
        return TriggerTimeUtils.computeNextTriggerTime(job, now);
    }

    private static Long doComputeNextTriggerTime(SchedJob job, Date now) {
        if (TriggerType.FIXED_DELAY.equalsValue(job.getTriggerType())) {
            return Long.MAX_VALUE;
        }
        return TriggerTimeUtils.computeNextTriggerTime(job, now);
    }

    private boolean checkBlockCollidedTrigger(SchedJob job, Date now) {
        Long lastTriggerTime;
        CollidedStrategy collidedStrategy = CollidedStrategy.of((Integer)job.getCollidedStrategy());
        if (CollidedStrategy.CONCURRENT == collidedStrategy || (lastTriggerTime = job.getLastTriggerTime()) == null) {
            return false;
        }
        SchedInstance lastInstance = this.jobQuerier.getInstance(job.getJobId(), lastTriggerTime, RunType.SCHEDULE.value());
        if (lastInstance == null) {
            return false;
        }
        long instanceId = lastInstance.getInstanceId();
        RunState runState = RunState.of((Integer)lastInstance.getRunState());
        switch (runState) {
            case FINISHED: {
                return false;
            }
            case WAITING: 
            case PAUSED: {
                return this.checkBlockCollidedTrigger(job, Collections.singletonList(lastInstance), collidedStrategy, now);
            }
            case RUNNING: {
                List<SchedTask> tasks = this.jobQuerier.findBaseInstanceTasks(instanceId);
                if (this.jobManager.hasAliveExecuting(tasks)) {
                    return this.checkBlockCollidedTrigger(job, Collections.singletonList(lastInstance), collidedStrategy, now);
                }
                this.log.info("All worker dead, terminate collided sched instance: {}", (Object)instanceId);
                this.jobManager.cancelInstance(lastInstance.obtainLockInstanceId(), Operation.COLLIDED_CANCEL);
                return false;
            }
            case CANCELED: {
                List<SchedInstance> list = this.jobQuerier.findUnterminatedRetryInstance(instanceId);
                if (CollectionUtils.isEmpty(list)) {
                    return false;
                }
                return this.checkBlockCollidedTrigger(job, list, collidedStrategy, now);
            }
        }
        throw new UnsupportedOperationException("Unsupported run state: " + runState.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkBlockCollidedTrigger(SchedJob job, List<SchedInstance> instances, CollidedStrategy collidedStrategy, Date now) {
        if (TriggerType.FIXED_DELAY.equalsValue(job.getTriggerType())) {
            SchedInstance first = instances.get(0);
            this.log.error("Fixed delay trigger type cannot happen run collided: {}, {}", (Object)first.obtainRnstanceId(), (Object)job.getNextTriggerTime());
        }
        switch (collidedStrategy) {
            case DISCARD: {
                Integer misfireStrategy = job.getMisfireStrategy();
                try {
                    job.setMisfireStrategy(Integer.valueOf(MisfireStrategy.DISCARD.value()));
                    job.setNextTriggerTime(TriggeringJobScanner.doComputeNextTriggerTime(job, now));
                }
                finally {
                    job.setMisfireStrategy(misfireStrategy);
                }
                if (job.getNextTriggerTime() == null) {
                    job.setRemark("Disable collided reason: has not next trigger time.");
                    job.setJobState(Integer.valueOf(JobState.DISABLE.value()));
                }
                this.jobManager.updateJobNextTriggerTime(job);
                return true;
            }
            case SERIAL: {
                this.updateNextScanTime(job, now, 60);
                return true;
            }
            case OVERRIDE: {
                instances.forEach(e -> this.jobManager.cancelInstance(e.obtainLockInstanceId(), Operation.COLLIDED_CANCEL));
                return false;
            }
        }
        throw new UnsupportedOperationException("Unsupported collided strategy: " + collidedStrategy.name());
    }

    private void updateNextScanTime(SchedJob job, Date now, int delayedSeconds) {
        job.setNextScanTime(Dates.plusSeconds((Date)now, (long)delayedSeconds));
        this.jobManager.updateJobNextScanTime(job);
    }

    private static void refreshNextTriggerTime(SchedJob job, Long lastTriggerTime, Date now) {
        job.setLastTriggerTime(lastTriggerTime);
        job.setNextTriggerTime(TriggeringJobScanner.doComputeNextTriggerTime(job, now));
        if (job.getNextTriggerTime() == null) {
            job.setRemark("Disable refresh reason: has not next trigger time");
            job.setJobState(Integer.valueOf(JobState.DISABLE.value()));
        }
    }
}

