package cn.ponfee.disjob.supervisor.application.converter;

import cn.ponfee.disjob.core.base.SupervisorMetrics;
import cn.ponfee.disjob.core.base.WorkerMetrics;
import cn.ponfee.disjob.supervisor.application.response.SupervisorMetricsResponse;
import cn.ponfee.disjob.supervisor.application.response.WorkerMetricsResponse;
import javax.annotation.Generated;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2024-08-18T19:49:41+0800",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 1.8.0_312 (Azul Systems, Inc.)"
)
public class ServerMetricsConverterImpl implements ServerMetricsConverter {

    @Override
    public SupervisorMetricsResponse convert(SupervisorMetrics source) {
        if ( source == null ) {
            return null;
        }

        SupervisorMetricsResponse supervisorMetricsResponse = new SupervisorMetricsResponse();

        supervisorMetricsResponse.setVersion( source.getVersion() );
        supervisorMetricsResponse.setStartupTime( CommonMapper.asString( source.getStartupTime() ) );
        supervisorMetricsResponse.setAlsoWorker( source.isAlsoWorker() );

        return supervisorMetricsResponse;
    }

    @Override
    public WorkerMetricsResponse convert(WorkerMetrics source) {
        if ( source == null ) {
            return null;
        }

        WorkerMetricsResponse workerMetricsResponse = new WorkerMetricsResponse();

        workerMetricsResponse.setClosed( sourceThreadPoolClosed( source ) );
        workerMetricsResponse.setKeepAliveTime( sourceThreadPoolKeepAliveTime( source ) );
        workerMetricsResponse.setMaximumPoolSize( sourceThreadPoolMaximumPoolSize( source ) );
        workerMetricsResponse.setCurrentPoolSize( sourceThreadPoolCurrentPoolSize( source ) );
        workerMetricsResponse.setActivePoolSize( sourceThreadPoolActivePoolSize( source ) );
        workerMetricsResponse.setIdlePoolSize( sourceThreadPoolIdlePoolSize( source ) );
        workerMetricsResponse.setQueueTaskCount( sourceThreadPoolQueueTaskCount( source ) );
        workerMetricsResponse.setCompletedTaskCount( sourceThreadPoolCompletedTaskCount( source ) );
        workerMetricsResponse.setVersion( source.getVersion() );
        workerMetricsResponse.setStartupTime( CommonMapper.asString( source.getStartupTime() ) );
        workerMetricsResponse.setWorkerId( source.getWorkerId() );
        workerMetricsResponse.setAlsoSupervisor( source.isAlsoSupervisor() );
        workerMetricsResponse.setJvmThreadActiveCount( source.getJvmThreadActiveCount() );

        return workerMetricsResponse;
    }

    private Boolean sourceThreadPoolClosed(WorkerMetrics workerMetrics) {
        if ( workerMetrics == null ) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        boolean closed = threadPool.isClosed();
        return closed;
    }

    private Long sourceThreadPoolKeepAliveTime(WorkerMetrics workerMetrics) {
        if ( workerMetrics == null ) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        long keepAliveTime = threadPool.getKeepAliveTime();
        return keepAliveTime;
    }

    private Integer sourceThreadPoolMaximumPoolSize(WorkerMetrics workerMetrics) {
        if ( workerMetrics == null ) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        int maximumPoolSize = threadPool.getMaximumPoolSize();
        return maximumPoolSize;
    }

    private Integer sourceThreadPoolCurrentPoolSize(WorkerMetrics workerMetrics) {
        if ( workerMetrics == null ) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        int currentPoolSize = threadPool.getCurrentPoolSize();
        return currentPoolSize;
    }

    private Integer sourceThreadPoolActivePoolSize(WorkerMetrics workerMetrics) {
        if ( workerMetrics == null ) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        int activePoolSize = threadPool.getActivePoolSize();
        return activePoolSize;
    }

    private Integer sourceThreadPoolIdlePoolSize(WorkerMetrics workerMetrics) {
        if ( workerMetrics == null ) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        int idlePoolSize = threadPool.getIdlePoolSize();
        return idlePoolSize;
    }

    private Long sourceThreadPoolQueueTaskCount(WorkerMetrics workerMetrics) {
        if ( workerMetrics == null ) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        long queueTaskCount = threadPool.getQueueTaskCount();
        return queueTaskCount;
    }

    private Long sourceThreadPoolCompletedTaskCount(WorkerMetrics workerMetrics) {
        if ( workerMetrics == null ) {
            return null;
        }
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        long completedTaskCount = threadPool.getCompletedTaskCount();
        return completedTaskCount;
    }
}
