package cn.ponfee.disjob.supervisor.application.converter;

import cn.ponfee.disjob.core.base.WorkerMetrics;
import cn.ponfee.disjob.supervisor.application.response.SupervisorMetricsResponse;
import cn.ponfee.disjob.supervisor.application.response.WorkerMetricsResponse;
import cn.ponfee.disjob.supervisor.base.SupervisorMetrics;
import javax.annotation.Generated;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2024-10-19T18:49:11+0800",
    comments = "version: 1.6.2, compiler: javac, environment: Java 1.8.0_312 (Azul Systems, Inc.)"
)
public class ServerMetricsConverterImpl implements ServerMetricsConverter {

    @Override
    public SupervisorMetricsResponse convert(SupervisorMetrics source) {
        if ( source == null ) {
            return null;
        }

        SupervisorMetricsResponse supervisorMetricsResponse = new SupervisorMetricsResponse();

        supervisorMetricsResponse.setVersion( source.getVersion() );
        supervisorMetricsResponse.setStartupTime( CommonConverter.asString( source.getStartupTime() ) );
        supervisorMetricsResponse.setAlsoWorker( source.isAlsoWorker() );

        return supervisorMetricsResponse;
    }

    @Override
    public WorkerMetricsResponse convert(WorkerMetrics source) {
        if ( source == null ) {
            return null;
        }

        WorkerMetricsResponse workerMetricsResponse = new WorkerMetricsResponse();

        workerMetricsResponse.setClosed( sourceThreadPoolClosed( source ) );
        workerMetricsResponse.setKeepAliveTime( sourceThreadPoolKeepAliveTime( source ) );
        workerMetricsResponse.setMaximumPoolSize( sourceThreadPoolMaximumPoolSize( source ) );
        workerMetricsResponse.setCurrentPoolSize( sourceThreadPoolCurrentPoolSize( source ) );
        workerMetricsResponse.setActivePoolSize( sourceThreadPoolActivePoolSize( source ) );
        workerMetricsResponse.setIdlePoolSize( sourceThreadPoolIdlePoolSize( source ) );
        workerMetricsResponse.setQueueTaskCount( sourceThreadPoolQueueTaskCount( source ) );
        workerMetricsResponse.setCompletedTaskCount( sourceThreadPoolCompletedTaskCount( source ) );
        workerMetricsResponse.setVersion( source.getVersion() );
        workerMetricsResponse.setStartupTime( CommonConverter.asString( source.getStartupTime() ) );
        workerMetricsResponse.setWorkerId( source.getWorkerId() );
        workerMetricsResponse.setAlsoSupervisor( source.isAlsoSupervisor() );
        workerMetricsResponse.setJvmThreadActiveCount( source.getJvmThreadActiveCount() );

        return workerMetricsResponse;
    }

    private Boolean sourceThreadPoolClosed(WorkerMetrics workerMetrics) {
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        return threadPool.isClosed();
    }

    private Long sourceThreadPoolKeepAliveTime(WorkerMetrics workerMetrics) {
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        return threadPool.getKeepAliveTime();
    }

    private Integer sourceThreadPoolMaximumPoolSize(WorkerMetrics workerMetrics) {
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        return threadPool.getMaximumPoolSize();
    }

    private Integer sourceThreadPoolCurrentPoolSize(WorkerMetrics workerMetrics) {
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        return threadPool.getCurrentPoolSize();
    }

    private Integer sourceThreadPoolActivePoolSize(WorkerMetrics workerMetrics) {
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        return threadPool.getActivePoolSize();
    }

    private Integer sourceThreadPoolIdlePoolSize(WorkerMetrics workerMetrics) {
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        return threadPool.getIdlePoolSize();
    }

    private Long sourceThreadPoolQueueTaskCount(WorkerMetrics workerMetrics) {
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        return threadPool.getQueueTaskCount();
    }

    private Long sourceThreadPoolCompletedTaskCount(WorkerMetrics workerMetrics) {
        WorkerMetrics.ThreadPoolMetrics threadPool = workerMetrics.getThreadPool();
        if ( threadPool == null ) {
            return null;
        }
        return threadPool.getCompletedTaskCount();
    }
}
