package cn.ponfee.disjob.supervisor.application.converter;

import cn.ponfee.disjob.core.base.WorkerMetrics;
import cn.ponfee.disjob.supervisor.application.response.SupervisorMetricsResponse;
import cn.ponfee.disjob.supervisor.application.response.WorkerMetricsResponse;
import cn.ponfee.disjob.supervisor.base.SupervisorMetrics;
import javax.annotation.Generated;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-08-02T18:06:21+0800",
    comments = "version: 1.6.3, compiler: javac, environment: Java 1.8.0_312 (Azul Systems, Inc.)"
)
public class ServerMetricsConverterImpl implements ServerMetricsConverter {

    @Override
    public SupervisorMetricsResponse convert(SupervisorMetrics source) {
        if ( source == null ) {
            return null;
        }

        SupervisorMetricsResponse supervisorMetricsResponse = new SupervisorMetricsResponse();

        supervisorMetricsResponse.setVersion( source.getVersion() );
        supervisorMetricsResponse.setStartupTime( CommonConverter.asString( source.getStartupTime() ) );
        supervisorMetricsResponse.setLastSubscribedEvent( source.getLastSubscribedEvent() );
        supervisorMetricsResponse.setAlsoWorker( source.isAlsoWorker() );

        return supervisorMetricsResponse;
    }

    @Override
    public WorkerMetricsResponse convert(WorkerMetrics source) {
        if ( source == null ) {
            return null;
        }

        WorkerMetricsResponse workerMetricsResponse = new WorkerMetricsResponse();

        workerMetricsResponse.setClosed( sourceWorkerThreadPoolMetricsClosed( source ) );
        workerMetricsResponse.setKeepAliveTime( sourceWorkerThreadPoolMetricsKeepAliveTime( source ) );
        workerMetricsResponse.setMaximumPoolSize( sourceWorkerThreadPoolMetricsMaximumPoolSize( source ) );
        workerMetricsResponse.setCurrentPoolSize( sourceWorkerThreadPoolMetricsCurrentPoolSize( source ) );
        workerMetricsResponse.setActivePoolSize( sourceWorkerThreadPoolMetricsActivePoolSize( source ) );
        workerMetricsResponse.setIdlePoolSize( sourceWorkerThreadPoolMetricsIdlePoolSize( source ) );
        workerMetricsResponse.setQueueTaskCount( sourceWorkerThreadPoolMetricsQueueTaskCount( source ) );
        workerMetricsResponse.setCompletedTaskCount( sourceWorkerThreadPoolMetricsCompletedTaskCount( source ) );
        workerMetricsResponse.setVersion( source.getVersion() );
        workerMetricsResponse.setStartupTime( CommonConverter.asString( source.getStartupTime() ) );
        workerMetricsResponse.setWorkerId( source.getWorkerId() );
        workerMetricsResponse.setAlsoSupervisor( source.isAlsoSupervisor() );
        workerMetricsResponse.setJvmThreadActiveCount( source.getJvmThreadActiveCount() );

        return workerMetricsResponse;
    }

    private Boolean sourceWorkerThreadPoolMetricsClosed(WorkerMetrics workerMetrics) {
        WorkerMetrics.WorkerThreadPoolMetrics workerThreadPoolMetrics = workerMetrics.getWorkerThreadPoolMetrics();
        if ( workerThreadPoolMetrics == null ) {
            return null;
        }
        return workerThreadPoolMetrics.isClosed();
    }

    private Long sourceWorkerThreadPoolMetricsKeepAliveTime(WorkerMetrics workerMetrics) {
        WorkerMetrics.WorkerThreadPoolMetrics workerThreadPoolMetrics = workerMetrics.getWorkerThreadPoolMetrics();
        if ( workerThreadPoolMetrics == null ) {
            return null;
        }
        return workerThreadPoolMetrics.getKeepAliveTime();
    }

    private Integer sourceWorkerThreadPoolMetricsMaximumPoolSize(WorkerMetrics workerMetrics) {
        WorkerMetrics.WorkerThreadPoolMetrics workerThreadPoolMetrics = workerMetrics.getWorkerThreadPoolMetrics();
        if ( workerThreadPoolMetrics == null ) {
            return null;
        }
        return workerThreadPoolMetrics.getMaximumPoolSize();
    }

    private Integer sourceWorkerThreadPoolMetricsCurrentPoolSize(WorkerMetrics workerMetrics) {
        WorkerMetrics.WorkerThreadPoolMetrics workerThreadPoolMetrics = workerMetrics.getWorkerThreadPoolMetrics();
        if ( workerThreadPoolMetrics == null ) {
            return null;
        }
        return workerThreadPoolMetrics.getCurrentPoolSize();
    }

    private Integer sourceWorkerThreadPoolMetricsActivePoolSize(WorkerMetrics workerMetrics) {
        WorkerMetrics.WorkerThreadPoolMetrics workerThreadPoolMetrics = workerMetrics.getWorkerThreadPoolMetrics();
        if ( workerThreadPoolMetrics == null ) {
            return null;
        }
        return workerThreadPoolMetrics.getActivePoolSize();
    }

    private Integer sourceWorkerThreadPoolMetricsIdlePoolSize(WorkerMetrics workerMetrics) {
        WorkerMetrics.WorkerThreadPoolMetrics workerThreadPoolMetrics = workerMetrics.getWorkerThreadPoolMetrics();
        if ( workerThreadPoolMetrics == null ) {
            return null;
        }
        return workerThreadPoolMetrics.getIdlePoolSize();
    }

    private Long sourceWorkerThreadPoolMetricsQueueTaskCount(WorkerMetrics workerMetrics) {
        WorkerMetrics.WorkerThreadPoolMetrics workerThreadPoolMetrics = workerMetrics.getWorkerThreadPoolMetrics();
        if ( workerThreadPoolMetrics == null ) {
            return null;
        }
        return workerThreadPoolMetrics.getQueueTaskCount();
    }

    private Long sourceWorkerThreadPoolMetricsCompletedTaskCount(WorkerMetrics workerMetrics) {
        WorkerMetrics.WorkerThreadPoolMetrics workerThreadPoolMetrics = workerMetrics.getWorkerThreadPoolMetrics();
        if ( workerThreadPoolMetrics == null ) {
            return null;
        }
        return workerThreadPoolMetrics.getCompletedTaskCount();
    }
}
