/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor;

import cn.ponfee.disjob.common.base.SingletonClassConstraint;
import cn.ponfee.disjob.common.base.Startable;
import cn.ponfee.disjob.common.concurrent.TripleState;
import cn.ponfee.disjob.common.exception.Throwables;
import cn.ponfee.disjob.common.util.TablePrinter;
import cn.ponfee.disjob.core.base.JobConstants;
import cn.ponfee.disjob.core.base.Server;
import cn.ponfee.disjob.core.base.Supervisor;
import cn.ponfee.disjob.dispatch.TaskDispatcher;
import cn.ponfee.disjob.registry.SupervisorRegistry;
import cn.ponfee.disjob.supervisor.configuration.SupervisorProperties;
import cn.ponfee.disjob.supervisor.scanner.RunningInstanceScanner;
import cn.ponfee.disjob.supervisor.scanner.TriggeringJobScanner;
import cn.ponfee.disjob.supervisor.scanner.WaitingInstanceScanner;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupervisorStartup
extends SingletonClassConstraint
implements Startable {
    private static final Logger LOG = LoggerFactory.getLogger(SupervisorStartup.class);
    private final Supervisor.Local localSupervisor;
    private final SupervisorProperties supervisorConf;
    private final SupervisorRegistry supervisorRegistry;
    private final TaskDispatcher taskDispatcher;
    private final WaitingInstanceScanner waitingInstanceScanner;
    private final RunningInstanceScanner runningInstanceScanner;
    private final TriggeringJobScanner triggeringJobScanner;
    private final TripleState state = TripleState.create();

    public SupervisorStartup(Supervisor.Local localSupervisor, SupervisorProperties supervisorConf, SupervisorRegistry supervisorRegistry, TaskDispatcher taskDispatcher, WaitingInstanceScanner waitingInstanceScanner, RunningInstanceScanner runningInstanceScanner, TriggeringJobScanner triggeringJobScanner) {
        this.localSupervisor = Objects.requireNonNull(localSupervisor, "Local supervisor cannot be null.");
        this.supervisorConf = Objects.requireNonNull(supervisorConf, "Supervisor properties cannot be null.");
        this.supervisorRegistry = Objects.requireNonNull(supervisorRegistry, "Supervisor registry cannot be null.");
        this.taskDispatcher = Objects.requireNonNull(taskDispatcher, "Task dispatcher cannot be null.");
        this.waitingInstanceScanner = Objects.requireNonNull(waitingInstanceScanner, "Waiting instance scanner cannot be null.");
        this.runningInstanceScanner = Objects.requireNonNull(runningInstanceScanner, "Running instance scanner cannot be null.");
        this.triggeringJobScanner = Objects.requireNonNull(triggeringJobScanner, "Triggering job scanner cannot be null.");
    }

    public void start() {
        if (!this.state.start()) {
            LOG.warn("Supervisor start failed, current state: {}", (Object)this.state);
            return;
        }
        LOG.info("Supervisor start begin: {}", (Object)this.localSupervisor);
        this.waitingInstanceScanner.start();
        this.runningInstanceScanner.start();
        this.triggeringJobScanner.start();
        Throwables.ThrowingRunnable.doCaught(() -> ((SupervisorRegistry)this.supervisorRegistry).discoverServers());
        this.supervisorRegistry.register((Server)this.localSupervisor);
        SupervisorStartup.printBanner(this.supervisorConf.isPrintBannerEnabled());
        LOG.info("Supervisor start end: {}", (Object)this.localSupervisor);
    }

    public void stop() {
        if (!this.state.stop()) {
            LOG.warn("Supervisor stop failed, current state: {}", (Object)this.state);
            return;
        }
        LOG.info("Supervisor stop begin: {}", (Object)this.localSupervisor);
        Throwables.ThrowingRunnable.doCaught(() -> ((TriggeringJobScanner)this.triggeringJobScanner).toStop());
        Throwables.ThrowingRunnable.doCaught(() -> ((RunningInstanceScanner)this.runningInstanceScanner).toStop());
        Throwables.ThrowingRunnable.doCaught(() -> ((WaitingInstanceScanner)this.waitingInstanceScanner).toStop());
        Throwables.ThrowingRunnable.doCaught(() -> ((SupervisorRegistry)this.supervisorRegistry).close());
        Throwables.ThrowingRunnable.doCaught(() -> ((TaskDispatcher)this.taskDispatcher).close());
        Throwables.ThrowingRunnable.doCaught(this.triggeringJobScanner::close);
        Throwables.ThrowingRunnable.doCaught(() -> ((RunningInstanceScanner)this.runningInstanceScanner).close());
        Throwables.ThrowingRunnable.doCaught(() -> ((WaitingInstanceScanner)this.waitingInstanceScanner).close());
        LOG.info("Supervisor stop end: {}", (Object)this.localSupervisor);
    }

    public boolean isRunning() {
        return this.state.isRunning();
    }

    private static void printBanner(boolean enabled) {
        if (!enabled) {
            return;
        }
        List<String> banner = Arrays.asList("", "     ___ _      _       _        __                             _ ", "    /   (_)___ (_) ___ | |__    / _\\_   _ _ __   ___ _ ____   _(_)___  ___  _ __ ", "   / /\\ / / __|| |/ _ \\| '_ \\   \\ \\| | | | '_ \\ / _ \\ '__\\ \\ / / / __|/ _ \\| '__| ", "  / /_//| \\__ \\| | (_) | |_) |  _\\ \\ |_| | |_) |  __/ |   \\ V /| \\__ \\ (_) | | ", " /___,' |_|___// |\\___/|_.__/   \\__/\\__,_| .__/ \\___|_|    \\_/ |_|___/\\___/|_| ", "             |__/                        |_| ", "", " Supervisor: " + Supervisor.local() + " ", " Version   : " + JobConstants.DISJOB_VERSION + " ", "");
        LOG.info("Disjob supervisor banner\n\n{}\n", (Object)TablePrinter.HALF.print(null, banner));
    }
}

