/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.application;

import cn.ponfee.disjob.common.base.SingletonClassConstraint;
import cn.ponfee.disjob.common.concurrent.ThreadPoolExecutors;
import cn.ponfee.disjob.common.date.Dates;
import cn.ponfee.disjob.core.base.Supervisor;
import cn.ponfee.disjob.supervisor.application.SchedGroupService;
import cn.ponfee.disjob.supervisor.base.OperationEventType;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OperationEventService
extends SingletonClassConstraint {
    private static final Logger LOG = LoggerFactory.getLogger(OperationEventService.class);
    private static final long PERIOD_MS = 3000L;
    private static final Map<OperationEventType, Pair<Date, String>> MAP = new ConcurrentHashMap<OperationEventType, Pair<Date, String>>();
    private final SchedGroupService groupService;

    public OperationEventService(SchedGroupService groupService) {
        this.groupService = groupService;
        long initialDelay = 3000L + ThreadLocalRandom.current().nextLong(3000L);
        ThreadPoolExecutors.commonScheduledPool().scheduleWithFixedDelay(this::process, initialDelay, 3000L, TimeUnit.MILLISECONDS);
    }

    public static void subscribe(OperationEventType eventType, Date eventTime, String eventData) {
        if (eventType != null) {
            MAP.put(eventType, (Pair<Date, String>)Pair.of((Object)eventTime, (Object)eventData));
        }
    }

    private void process() {
        ArrayList<OperationEventType> list = new ArrayList<OperationEventType>(MAP.keySet());
        for (OperationEventType eventType : list) {
            Pair<Date, String> pair = MAP.remove((Object)eventType);
            if (pair == null) continue;
            try {
                this.process(eventType, (Date)pair.getLeft(), (String)pair.getRight());
                LOG.info("Process operation event success: {}, {}", (Object)eventType, pair);
            }
            catch (Throwable t) {
                LOG.error("Process operation event error: " + (Object)((Object)eventType) + ", " + pair, t);
            }
        }
    }

    private void process(OperationEventType eventType, Date eventTime, String eventData) {
        boolean state = true;
        if (eventType == OperationEventType.REFRESH_GROUP) {
            this.groupService.refresh();
        } else {
            state = false;
            LOG.error("Unsupported subscribe operation event type: {}", (Object)eventType);
        }
        if (state) {
            Supervisor.local().updateLastSubscribedEvent(Dates.format((Date)eventTime) + " - " + (Object)((Object)eventType));
        }
    }
}

