/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.application;

import cn.ponfee.disjob.common.base.SingletonClassConstraint;
import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.concurrent.ThreadPoolExecutors;
import cn.ponfee.disjob.common.concurrent.Threads;
import cn.ponfee.disjob.common.model.PageResponse;
import cn.ponfee.disjob.common.spring.TransactionUtils;
import cn.ponfee.disjob.common.util.Functions;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.enums.TokenType;
import cn.ponfee.disjob.supervisor.application.ServerInvokeService;
import cn.ponfee.disjob.supervisor.application.converter.SchedGroupConverter;
import cn.ponfee.disjob.supervisor.application.request.SchedGroupAddRequest;
import cn.ponfee.disjob.supervisor.application.request.SchedGroupPageRequest;
import cn.ponfee.disjob.supervisor.application.request.SchedGroupUpdateRequest;
import cn.ponfee.disjob.supervisor.application.response.SchedGroupResponse;
import cn.ponfee.disjob.supervisor.application.value.DisjobGroup;
import cn.ponfee.disjob.supervisor.base.OperationEventType;
import cn.ponfee.disjob.supervisor.component.WorkerClient;
import cn.ponfee.disjob.supervisor.configuration.SupervisorProperties;
import cn.ponfee.disjob.supervisor.dao.mapper.SchedGroupMapper;
import cn.ponfee.disjob.supervisor.exception.GroupNotFoundException;
import cn.ponfee.disjob.supervisor.exception.KeyExistsException;
import cn.ponfee.disjob.supervisor.model.SchedGroup;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SchedGroupService
extends SingletonClassConstraint {
    private static final Logger LOG = LoggerFactory.getLogger(SchedGroupService.class);
    private static final Lock LOCK = new ReentrantLock();
    private static final AtomicReference<Cache> CACHE = new AtomicReference<Cache>(Cache.empty());
    private final SchedGroupMapper groupMapper;
    private final WorkerClient workerClient;
    private final ServerInvokeService serverInvokeService;

    public SchedGroupService(SchedGroupMapper groupMapper, WorkerClient workerClient, ServerInvokeService serverInvokeService, SupervisorProperties supervisorConf) {
        this.groupMapper = groupMapper;
        this.workerClient = workerClient;
        this.serverInvokeService = serverInvokeService;
        supervisorConf.check();
        int periodMinutes = supervisorConf.getGroupRefreshPeriodMinutes();
        if (periodMinutes > 0) {
            ThreadPoolExecutors.commonScheduledPool().scheduleWithFixedDelay(this::refresh, periodMinutes, periodMinutes, TimeUnit.MINUTES);
        }
        this.refresh();
    }

    public long add(String user, SchedGroupAddRequest request) {
        request.checkAndTrim();
        if (this.groupMapper.exists(request.getGroup())) {
            throw new KeyExistsException("Group already exists: " + request.getGroup());
        }
        SchedGroup schedGroup = request.toSchedGroup(user);
        this.groupMapper.insert(schedGroup);
        this.refreshAndPublish();
        return schedGroup.getId();
    }

    public boolean delete(String user, String group) {
        List<Worker> workers = this.workerClient.getAliveWorkers(group);
        if (CollectionUtils.isNotEmpty(workers)) {
            throw new KeyExistsException("Group '" + group + "' has registered workers, cannot delete.");
        }
        return Functions.doIfTrue((boolean)TransactionUtils.isOneAffectedRow((int)this.groupMapper.softDelete(group, user)), this::refreshAndPublish);
    }

    public boolean update(String user, SchedGroupUpdateRequest request) {
        request.checkAndTrim();
        return Functions.doIfTrue((boolean)TransactionUtils.isOneAffectedRow((int)this.groupMapper.update(request.toSchedGroup(user))), this::refreshAndPublish);
    }

    public SchedGroupResponse get(String group) {
        return SchedGroupConverter.INSTANCE.convert(this.groupMapper.get(group));
    }

    public boolean updateToken(String user, String group, TokenType type, String newToken, String oldToken) {
        return Functions.doIfTrue((boolean)TransactionUtils.isOneAffectedRow((int)this.groupMapper.updateToken(group, type, newToken, user, oldToken)), this::refreshAndPublish);
    }

    public boolean updateOwnUser(String user, String group, String ownUser) {
        ownUser = SchedGroup.checkOwnUser(ownUser);
        return Functions.doIfTrue((boolean)TransactionUtils.isOneAffectedRow((int)this.groupMapper.updateOwnUser(group, ownUser, user)), this::refreshAndPublish);
    }

    public List<String> searchGroup(String term) {
        return this.groupMapper.searchGroup(term);
    }

    public PageResponse<SchedGroupResponse> queryForPage(SchedGroupPageRequest pageRequest) {
        PageResponse page = pageRequest.query(this.groupMapper::queryPageCount, this.groupMapper::queryPageRecords, SchedGroupConverter.INSTANCE::convert);
        page.forEachRow(SchedGroupResponse::maskToken);
        return page;
    }

    public static ImmutableSet<String> myGroups(String user) {
        return CACHE.get().myGroups(user);
    }

    public static DisjobGroup getGroup(String group) {
        return CACHE.get().getGroup(group);
    }

    void refresh() {
        if (LOCK.tryLock()) {
            try {
                CACHE.set(Cache.of(this.groupMapper.findAll()));
            }
            catch (Throwable t) {
                LOG.error("Refresh sched group error.", t);
                Threads.interruptIfNecessary((Throwable)t);
            }
            finally {
                LOCK.unlock();
            }
        }
    }

    private void refreshAndPublish() {
        this.refresh();
        this.serverInvokeService.publishOperationEvent(OperationEventType.REFRESH_GROUP, null, false);
    }

    private static class Cache {
        final Map<String, DisjobGroup> groupMap;
        final Map<String, ImmutableSet<String>> userMap;

        Cache(Map<String, DisjobGroup> groupMap, Map<String, ImmutableSet<String>> userMap) {
            this.groupMap = groupMap;
            this.userMap = userMap;
        }

        static Cache empty() {
            return new Cache(Collections.emptyMap(), Collections.emptyMap());
        }

        static Cache of(List<SchedGroup> groups) {
            List list = groups.stream().map(DisjobGroup::new).collect(Collectors.toList());
            Map groupMap = Collects.toMap(list, DisjobGroup::getGroup);
            Map<String, ImmutableSet<String>> userMap = list.stream().flatMap(e -> Stream.concat(e.getDevUsers().stream(), Stream.of(e.getOwnUser())).map(u -> Pair.of((Object)u, (Object)e.getGroup()))).collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, ImmutableSet.toImmutableSet())));
            return new Cache(groupMap, userMap);
        }

        DisjobGroup getGroup(String group) {
            DisjobGroup disjobGroup = this.groupMap.get(group);
            if (disjobGroup == null) {
                throw new GroupNotFoundException("Not found worker group: " + group);
            }
            return disjobGroup;
        }

        ImmutableSet<String> myGroups(String user) {
            ImmutableSet<String> groups = this.userMap.get(user);
            return groups == null ? ImmutableSet.of() : groups;
        }
    }
}

