/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.application;

import cn.ponfee.disjob.common.base.SingletonClassConstraint;
import cn.ponfee.disjob.common.model.CodeMsg;
import cn.ponfee.disjob.common.model.PageResponse;
import cn.ponfee.disjob.core.base.JobCodeMsg;
import cn.ponfee.disjob.core.enums.ExecuteState;
import cn.ponfee.disjob.core.enums.JobState;
import cn.ponfee.disjob.core.enums.Operation;
import cn.ponfee.disjob.core.exception.JobException;
import cn.ponfee.disjob.core.exception.JobRuntimeException;
import cn.ponfee.disjob.supervisor.application.converter.SchedJobConverter;
import cn.ponfee.disjob.supervisor.application.request.SchedInstancePageRequest;
import cn.ponfee.disjob.supervisor.application.request.SchedJobAddRequest;
import cn.ponfee.disjob.supervisor.application.request.SchedJobPageRequest;
import cn.ponfee.disjob.supervisor.application.request.SchedJobSearchRequest;
import cn.ponfee.disjob.supervisor.application.request.SchedJobUpdateRequest;
import cn.ponfee.disjob.supervisor.application.response.SchedInstanceResponse;
import cn.ponfee.disjob.supervisor.application.response.SchedJobResponse;
import cn.ponfee.disjob.supervisor.application.response.SchedTaskResponse;
import cn.ponfee.disjob.supervisor.component.JobManager;
import cn.ponfee.disjob.supervisor.component.JobQuerier;
import cn.ponfee.disjob.supervisor.model.SchedInstance;
import cn.ponfee.disjob.supervisor.model.SchedJob;
import cn.ponfee.disjob.supervisor.model.SchedTask;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SchedJobService
extends SingletonClassConstraint {
    private static final Logger LOG = LoggerFactory.getLogger(SchedJobService.class);
    private final JobManager jobManager;
    private final JobQuerier jobQuerier;

    public Long addJob(String user, SchedJobAddRequest req) throws JobException {
        LOG.info("Adding job by {}: {}", (Object)user, (Object)req);
        return this.jobManager.addJob(req.tosSchedJob(user));
    }

    public void updateJob(String user, SchedJobUpdateRequest req) throws JobException {
        LOG.info("Updating job by {}: {}", (Object)user, (Object)req);
        this.jobManager.updateJob(req.tosSchedJob(user));
    }

    public void deleteJob(String user, long jobId) {
        LOG.info("Deleting job by {}: {}", (Object)user, (Object)jobId);
        this.jobManager.deleteJob(user, jobId);
    }

    public void changeJobState(String user, long jobId, int toJobState) {
        JobState toState = JobState.of((int)toJobState);
        LOG.info("Changing job state by {}: {}, {}", new Object[]{user, jobId, toState});
        this.jobManager.changeJobState(user, jobId, toState);
    }

    public void manualTriggerJob(String user, long jobId) throws JobException {
        LOG.info("Manual trigger job by {}: {}", (Object)user, (Object)jobId);
        this.jobManager.manualTriggerJob(jobId);
    }

    public SchedJobResponse getJob(long jobId) {
        SchedJob job = this.jobQuerier.getJob(jobId);
        Assert.notNull((Object)((Object)job), () -> "Job not found: " + jobId);
        return SchedJobConverter.INSTANCE.convert(job);
    }

    public PageResponse<SchedJobResponse> queryJobForPage(SchedJobPageRequest pageRequest) {
        return this.jobQuerier.queryJobForPage(pageRequest);
    }

    public List<Map<String, Object>> searchJob(SchedJobSearchRequest req) {
        return this.jobQuerier.searchJob(req);
    }

    public void pauseInstance(String user, long instanceId) {
        LOG.info("Pausing instance by {}: {}", (Object)user, (Object)instanceId);
        if (!this.jobManager.pauseInstance(instanceId)) {
            throw new JobRuntimeException((CodeMsg)JobCodeMsg.NOT_PAUSABLE_INSTANCE);
        }
    }

    public void cancelInstance(String user, long instanceId) {
        LOG.info("Canceling instance by {}: {}", (Object)user, (Object)instanceId);
        if (!this.jobManager.cancelInstance(instanceId, Operation.MANUAL_CANCEL)) {
            throw new JobRuntimeException((CodeMsg)JobCodeMsg.NOT_CANCELABLE_INSTANCE);
        }
    }

    public void resumeInstance(String user, long instanceId) {
        LOG.info("Resuming instance by {}: {}", (Object)user, (Object)instanceId);
        if (!this.jobManager.resumeInstance(instanceId)) {
            throw new JobRuntimeException((CodeMsg)JobCodeMsg.NOT_RESUMABLE_INSTANCE);
        }
    }

    public void changeInstanceState(String user, long instanceId, int toExecuteState) {
        ExecuteState toState = ExecuteState.of((Integer)toExecuteState);
        LOG.info("Changing instance state by {}: {}, {}", new Object[]{user, instanceId, toState});
        this.jobManager.changeInstanceState(instanceId, toState);
    }

    public void deleteInstance(String user, long instanceId) {
        LOG.info("Deleting instance by {}: {}", (Object)user, (Object)instanceId);
        this.jobManager.deleteInstance(instanceId);
    }

    public SchedInstanceResponse getInstance(long instanceId, boolean includeTasks) {
        SchedInstance instance = this.jobQuerier.getInstance(instanceId);
        Assert.notNull((Object)((Object)instance), () -> "Instance not found: " + instanceId);
        List<SchedTask> tasks = includeTasks ? this.jobQuerier.findLargeInstanceTasks(instanceId) : null;
        return SchedInstanceResponse.of(instance, tasks);
    }

    public List<SchedTaskResponse> getInstanceTasks(long instanceId) {
        List<SchedTask> tasks = this.jobQuerier.findLargeInstanceTasks(instanceId);
        return tasks.stream().map(SchedJobConverter.INSTANCE::convert).collect(Collectors.toList());
    }

    public PageResponse<SchedInstanceResponse> queryInstanceForPage(SchedInstancePageRequest req) {
        return this.jobQuerier.queryInstanceForPage(req);
    }

    public List<SchedInstanceResponse> listInstanceChildren(long pnstanceId) {
        return this.jobQuerier.listInstanceChildren(pnstanceId);
    }

    public SchedJobService(JobManager jobManager, JobQuerier jobQuerier) {
        this.jobManager = jobManager;
        this.jobQuerier = jobQuerier;
    }
}

