/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.application;

import cn.ponfee.disjob.common.base.RetryTemplate;
import cn.ponfee.disjob.common.base.SingletonClassConstraint;
import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.concurrent.MultithreadExecutors;
import cn.ponfee.disjob.common.concurrent.ThreadPoolExecutors;
import cn.ponfee.disjob.common.util.Numbers;
import cn.ponfee.disjob.core.base.RetryProperties;
import cn.ponfee.disjob.core.base.Server;
import cn.ponfee.disjob.core.base.Supervisor;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.base.WorkerMetrics;
import cn.ponfee.disjob.core.dto.worker.ConfigureWorkerParam;
import cn.ponfee.disjob.core.dto.worker.GetMetricsParam;
import cn.ponfee.disjob.core.exception.AuthenticationException;
import cn.ponfee.disjob.registry.Registry;
import cn.ponfee.disjob.registry.rpc.DestinationServerRestProxy;
import cn.ponfee.disjob.supervisor.application.converter.ServerMetricsConverter;
import cn.ponfee.disjob.supervisor.application.request.ConfigureAllWorkerRequest;
import cn.ponfee.disjob.supervisor.application.request.ConfigureOneWorkerRequest;
import cn.ponfee.disjob.supervisor.application.response.SupervisorMetricsResponse;
import cn.ponfee.disjob.supervisor.application.response.WorkerMetricsResponse;
import cn.ponfee.disjob.supervisor.base.ExtendedSupervisorRpcService;
import cn.ponfee.disjob.supervisor.base.OperationEventType;
import cn.ponfee.disjob.supervisor.base.SupervisorMetrics;
import cn.ponfee.disjob.supervisor.component.WorkerClient;
import cn.ponfee.disjob.supervisor.exception.KeyExistsException;
import cn.ponfee.disjob.supervisor.exception.KeyNotExistsException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class ServerInvokeService
extends SingletonClassConstraint {
    private static final Logger LOG = LoggerFactory.getLogger(ServerInvokeService.class);
    private final WorkerClient workerClient;
    private final Registry<Supervisor> supervisorRegistry;
    private final Supervisor.Local localSupervisor;
    private final DestinationServerRestProxy<ExtendedSupervisorRpcService, Supervisor> supervisorRpcProxy;

    public ServerInvokeService(WorkerClient workerClient, Registry<Supervisor> supervisorRegistry, Supervisor.Local localSupervisor, ExtendedSupervisorRpcService localSupervisorRpcProvider, @Qualifier(value="disjob.bean.rest-template") RestTemplate restTemplate) {
        this.workerClient = workerClient;
        this.supervisorRegistry = supervisorRegistry;
        this.localSupervisor = localSupervisor;
        this.supervisorRpcProxy = DestinationServerRestProxy.of(ExtendedSupervisorRpcService.class, (Object)localSupervisorRpcProvider, (Server)localSupervisor, (RestTemplate)restTemplate, (RetryProperties)RetryProperties.none());
    }

    public List<SupervisorMetricsResponse> supervisors() {
        List list = this.supervisorRegistry.getRegisteredServers();
        list = Collects.sorted((List)list, Comparator.comparing(e -> this.localSupervisor.equals(e) ? 0 : 1));
        return MultithreadExecutors.call((Collection)list, this::getSupervisorMetrics, (Executor)ThreadPoolExecutors.commonThreadPool());
    }

    public List<WorkerMetricsResponse> workers(String group) {
        List list = this.workerClient.getAliveWorkers(group);
        list = Collects.sorted(list, Comparator.comparing(e -> e.equals((Object)Worker.local()) ? 0 : 1));
        return MultithreadExecutors.call((Collection)list, this::getWorkerMetrics, (Executor)ThreadPoolExecutors.commonThreadPool());
    }

    public WorkerMetricsResponse worker(String group, String worker) {
        String[] array;
        if (StringUtils.isBlank((CharSequence)worker) || (array = worker.split(":", 2)).length != 2) {
            return null;
        }
        String host = array[0];
        Integer port = Numbers.toWrapInt((Object)StringUtils.trim((String)array[1]));
        if (StringUtils.isBlank((CharSequence)host) || port == null) {
            return null;
        }
        WorkerMetricsResponse metrics = this.getWorkerMetrics(new Worker(group, "-", host.trim(), port.intValue()));
        return StringUtils.isBlank((CharSequence)metrics.getWorkerId()) ? null : metrics;
    }

    public void configureOneWorker(ConfigureOneWorkerRequest req) {
        Worker worker = req.toWorker();
        if (req.getAction() == ConfigureWorkerParam.Action.ADD_WORKER) {
            List<Worker> workers = this.workerClient.getAliveWorkers(req.getGroup());
            if (workers != null) {
                if (workers.stream().anyMatch(arg_0 -> ((Worker)worker).matches(arg_0))) {
                    throw new KeyExistsException("Worker already registered: " + worker);
                }
            }
        } else {
            List<Worker> workers = this.getRequiredAliveWorkers(req.getGroup());
            if (!workers.contains(worker)) {
                throw new KeyNotExistsException("Not found worker: " + worker);
            }
        }
        this.configureWorker(worker, req.getAction(), req.getData());
    }

    public void configureAllWorker(ConfigureAllWorkerRequest req) {
        List<Worker> workers = this.getRequiredAliveWorkers(req.getGroup());
        Consumer<Worker> action = worker -> this.configureWorker((Worker)worker, req.getAction(), req.getData());
        MultithreadExecutors.run(workers, action, (Executor)ThreadPoolExecutors.commonThreadPool());
    }

    public void publishOperationEvent(OperationEventType eventType, String eventData, boolean includeSelf) {
        try {
            List supervisors = this.supervisorRegistry.getRegisteredServers().stream().filter(e -> includeSelf || !this.localSupervisor.equals(e)).collect(Collectors.toList());
            Date eventTime = new Date();
            Consumer<Supervisor> action = supervisor -> this.publishOperationEvent((Supervisor)supervisor, eventType, eventTime, eventData);
            MultithreadExecutors.run(supervisors, action, (Executor)ThreadPoolExecutors.commonThreadPool());
        }
        catch (Exception e2) {
            LOG.error("Publish operation event to other supervisor error.", (Throwable)e2);
        }
    }

    private SupervisorMetricsResponse getSupervisorMetrics(Supervisor supervisor) {
        SupervisorMetrics metrics = null;
        Long responseTime = null;
        try {
            long start = System.currentTimeMillis();
            metrics = ((ExtendedSupervisorRpcService)this.supervisorRpcProxy.destination((Server)supervisor)).getMetrics();
            responseTime = System.currentTimeMillis() - start;
        }
        catch (Throwable e) {
            LOG.warn("Gets supervisor metrics occur error: {} {}", (Object)supervisor, (Object)e.getMessage());
        }
        SupervisorMetricsResponse response = metrics == null ? new SupervisorMetricsResponse() : ServerMetricsConverter.INSTANCE.convert(metrics);
        response.setHost(supervisor.getHost());
        response.setPort(supervisor.getPort());
        response.setResponseTime(responseTime);
        return response;
    }

    private WorkerMetricsResponse getWorkerMetrics(Worker worker) {
        WorkerMetrics metrics = null;
        Long responseTime = null;
        GetMetricsParam param = GetMetricsParam.of((String)worker.getGroup());
        try {
            long start = System.currentTimeMillis();
            metrics = this.workerClient.destination(worker).getMetrics(param);
            responseTime = System.currentTimeMillis() - start;
        }
        catch (Throwable e) {
            LOG.warn("Gets worker metrics occur error: {} {}", (Object)worker, (Object)e.getMessage());
        }
        WorkerMetricsResponse response = metrics == null || !Supervisor.local().verifyWorkerSignatureToken(worker.getGroup(), metrics.getSignature()) ? new WorkerMetricsResponse() : ServerMetricsConverter.INSTANCE.convert(metrics);
        response.setHost(worker.getHost());
        response.setPort(worker.getPort());
        response.setResponseTime(responseTime);
        return response;
    }

    private List<Worker> getRequiredAliveWorkers(String group) {
        List<Worker> workers = this.workerClient.getAliveWorkers(group);
        if (CollectionUtils.isEmpty(workers)) {
            throw new KeyNotExistsException("Group '" + group + "' not exists workers.");
        }
        return workers;
    }

    private void verifyWorkerSignature(Worker worker) {
        GetMetricsParam param = GetMetricsParam.of((String)worker.getGroup());
        WorkerMetrics metrics = this.workerClient.destination(worker).getMetrics(param);
        if (!Supervisor.local().verifyWorkerSignatureToken(worker.getGroup(), metrics.getSignature())) {
            throw new AuthenticationException("Worker authenticated failed: " + worker);
        }
    }

    private void configureWorker(Worker worker, ConfigureWorkerParam.Action action, String data) {
        if (action == ConfigureWorkerParam.Action.ADD_WORKER) {
            this.verifyWorkerSignature(worker);
        }
        ConfigureWorkerParam param = ConfigureWorkerParam.of((String)worker.getGroup(), (ConfigureWorkerParam.Action)action, (String)data);
        this.workerClient.destination(worker).configureWorker(param);
    }

    private void publishOperationEvent(Supervisor supervisor, OperationEventType eventType, Date eventTime, String eventData) {
        RetryTemplate.executeQuietly(() -> ((ExtendedSupervisorRpcService)this.supervisorRpcProxy.destination((Server)supervisor)).subscribeOperationEvent(eventType, eventTime, eventData), (int)1, (long)2000L);
    }
}

