/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.application.request;

import cn.ponfee.disjob.common.util.Strings;
import cn.ponfee.disjob.supervisor.application.converter.SchedGroupConverter;
import cn.ponfee.disjob.supervisor.application.request.SchedGroupAddRequest;
import cn.ponfee.disjob.supervisor.model.SchedGroup;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class SchedGroupUpdateRequest
extends SchedGroupAddRequest {
    private static final long serialVersionUID = 7531416191031943146L;
    private String devUsers;
    private String alertRecipients;
    private String alertWebhook;
    private String workerContextPath;
    private int version;

    @Override
    public SchedGroup toSchedGroup(String user) {
        SchedGroup schedGroup = SchedGroupConverter.INSTANCE.convert(this);
        schedGroup.setUpdatedBy(user);
        return schedGroup;
    }

    @Override
    public void checkAndTrim() {
        Assert.hasText((String)this.group, (String)"Group cannot be blank.");
        this.ownUser = SchedGroup.checkOwnUser(this.ownUser);
        this.devUsers = SchedGroupUpdateRequest.prune(this.devUsers);
        this.alertRecipients = SchedGroupUpdateRequest.prune(this.alertRecipients);
        this.alertWebhook = StringUtils.trim((String)this.alertWebhook);
        this.workerContextPath = Strings.trimPath((String)this.workerContextPath);
    }

    private static String prune(String str) {
        if (str == null) {
            return null;
        }
        return Arrays.stream(str.split(",")).filter(StringUtils::isNotBlank).map(String::trim).distinct().collect(Collectors.joining(","));
    }

    public String getDevUsers() {
        return this.devUsers;
    }

    public String getAlertRecipients() {
        return this.alertRecipients;
    }

    public String getAlertWebhook() {
        return this.alertWebhook;
    }

    public String getWorkerContextPath() {
        return this.workerContextPath;
    }

    public int getVersion() {
        return this.version;
    }

    public void setDevUsers(String devUsers) {
        this.devUsers = devUsers;
    }

    public void setAlertRecipients(String alertRecipients) {
        this.alertRecipients = alertRecipients;
    }

    public void setAlertWebhook(String alertWebhook) {
        this.alertWebhook = alertWebhook;
    }

    public void setWorkerContextPath(String workerContextPath) {
        this.workerContextPath = workerContextPath;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

