/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.application.value;

import cn.ponfee.disjob.common.util.Strings;
import cn.ponfee.disjob.supervisor.model.SchedGroup;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

public class DisjobGroup {
    private final String group;
    private final String supervisorToken;
    private final String workerToken;
    private final String userToken;
    private final String ownUser;
    private final ImmutableSet<String> devUsers;
    private final ImmutableSet<String> alertRecipients;
    private final String alertWebhook;
    private final String workerContextPath;

    public DisjobGroup(SchedGroup o) {
        this.group = o.getGroup();
        this.supervisorToken = o.getSupervisorToken();
        this.workerToken = o.getWorkerToken();
        this.userToken = o.getUserToken();
        this.ownUser = o.getOwnUser().trim();
        this.devUsers = DisjobGroup.parse(o.getDevUsers());
        this.alertRecipients = DisjobGroup.parse(o.getAlertRecipients());
        this.alertWebhook = o.getAlertWebhook();
        this.workerContextPath = Strings.trimPath((String)o.getWorkerContextPath());
    }

    private static ImmutableSet<String> parse(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return ImmutableSet.of();
        }
        String[] array = str.split(",");
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)array.length);
        Arrays.stream(array).filter(StringUtils::isNotBlank).map(String::trim).forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        return builder.build();
    }

    public String getGroup() {
        return this.group;
    }

    public String getSupervisorToken() {
        return this.supervisorToken;
    }

    public String getWorkerToken() {
        return this.workerToken;
    }

    public String getUserToken() {
        return this.userToken;
    }

    public String getOwnUser() {
        return this.ownUser;
    }

    public ImmutableSet<String> getDevUsers() {
        return this.devUsers;
    }

    public ImmutableSet<String> getAlertRecipients() {
        return this.alertRecipients;
    }

    public String getAlertWebhook() {
        return this.alertWebhook;
    }

    public String getWorkerContextPath() {
        return this.workerContextPath;
    }
}

