/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.auth;

import cn.ponfee.disjob.common.spring.SpringUtils;
import cn.ponfee.disjob.core.base.Supervisor;
import cn.ponfee.disjob.core.exception.AuthenticationException;
import cn.ponfee.disjob.supervisor.application.AuthorizeGroupService;
import cn.ponfee.disjob.supervisor.auth.SupervisorAuthentication;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class AuthenticationConfigurer
implements WebMvcConfigurer {
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new AuthenticationInterceptor()).order(Integer.MIN_VALUE);
    }

    public static String requestUser() {
        return AuthenticationConfigurer.getRequest().getHeader("X-Disjob-User");
    }

    public static String requestGroup() {
        return AuthenticationConfigurer.getRequest().getHeader("X-Disjob-Group");
    }

    private static String requestToken() {
        return AuthenticationConfigurer.getRequest().getHeader("X-Disjob-Token");
    }

    private static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    private static class AuthenticationInterceptor
    implements HandlerInterceptor {
        private static final String ERR_MSG = "Authenticate failed.";

        private AuthenticationInterceptor() {
        }

        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
            if (!(handler instanceof HandlerMethod)) {
                return true;
            }
            SupervisorAuthentication annotation = (SupervisorAuthentication)SpringUtils.getAnnotation((HandlerMethod)((HandlerMethod)handler), SupervisorAuthentication.class);
            if (annotation == null || annotation.value() == SupervisorAuthentication.Subject.ANON) {
                return true;
            }
            String group = AuthenticationConfigurer.requestGroup();
            if (StringUtils.isBlank((CharSequence)group)) {
                throw new AuthenticationException(ERR_MSG);
            }
            SupervisorAuthentication.Subject value = annotation.value();
            if (value == SupervisorAuthentication.Subject.WORKER) {
                AuthenticationInterceptor.authenticateWorker(group);
            } else if (value == SupervisorAuthentication.Subject.USER) {
                AuthenticationInterceptor.authenticateUser(group);
            } else {
                throw new UnsupportedOperationException("Unsupported supervisor authentication subject: " + (Object)((Object)value));
            }
            return true;
        }

        private static void authenticateWorker(String group) {
            if (!Supervisor.local().verifyWorkerAuthenticationToken(group, AuthenticationConfigurer.requestToken())) {
                throw new AuthenticationException(ERR_MSG);
            }
        }

        private static void authenticateUser(String group) {
            AuthorizeGroupService.authorizeGroup(AuthenticationConfigurer.requestUser(), group);
            if (!Supervisor.local().verifyUserAuthenticationToken(group, AuthenticationConfigurer.requestToken())) {
                throw new AuthenticationException(ERR_MSG);
            }
        }
    }
}

