/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.base;

import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.enums.JobType;
import cn.ponfee.disjob.core.enums.Operation;
import cn.ponfee.disjob.core.enums.RouteStrategy;
import cn.ponfee.disjob.core.enums.ShutdownStrategy;
import cn.ponfee.disjob.dispatch.ExecuteTaskParam;
import cn.ponfee.disjob.supervisor.model.SchedInstance;
import cn.ponfee.disjob.supervisor.model.SchedJob;
import java.util.Objects;
import org.springframework.util.Assert;

public final class ExecuteTaskParamBuilder {
    private final SchedJob job;
    private final SchedInstance instance;

    public ExecuteTaskParamBuilder(SchedJob job, SchedInstance instance) {
        if (!instance.getJobId().equals(job.getJobId())) {
            throw new IllegalArgumentException("Inconsistent job id: " + instance.getJobId() + "!=" + job.getJobId());
        }
        this.job = job;
        this.instance = instance;
    }

    public ExecuteTaskParam build(Operation operation, long taskId, long triggerTime, Worker worker) {
        ExecuteTaskParam param = new ExecuteTaskParam();
        param.setOperation(Objects.requireNonNull(operation, "Operation cannot be null."));
        param.setTaskId(taskId);
        param.setInstanceId(this.instance.getInstanceId().longValue());
        param.setWnstanceId(this.instance.getWnstanceId());
        param.setTriggerTime(triggerTime);
        param.setJobId(this.job.getJobId().longValue());
        param.setRetryCount(this.job.getRetryCount().intValue());
        param.setRetriedCount(this.instance.getRetriedCount().intValue());
        param.setJobType(JobType.of((int)this.job.getJobType()));
        param.setRouteStrategy(RouteStrategy.of((int)this.job.getRouteStrategy()));
        param.setShutdownStrategy(ShutdownStrategy.of((int)this.job.getShutdownStrategy()));
        param.setExecuteTimeout(this.job.getExecuteTimeout().intValue());
        param.fillSupervisorAuthenticationToken(this.job.getGroup());
        param.setWorker(worker);
        param.setJobExecutor(this.obtainJobExecutor());
        return param;
    }

    private String obtainJobExecutor() {
        if (!this.instance.isWorkflow()) {
            Assert.hasText((String)this.job.getJobExecutor(), () -> "General job executor cannot be null: " + this.job.getJobId());
            return this.job.getJobExecutor();
        }
        String curJobExecutor = this.instance.parseWorkflowCurNode().getName();
        Assert.hasText((String)curJobExecutor, () -> "Curr node job executor cannot be empty: " + this.instance.getInstanceId());
        return curJobExecutor;
    }
}

