/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.base;

import cn.ponfee.disjob.alert.base.AlertInstanceEvent;
import cn.ponfee.disjob.alert.base.AlertType;
import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.core.dag.PredecessorInstance;
import cn.ponfee.disjob.core.dag.PredecessorTask;
import cn.ponfee.disjob.core.dto.supervisor.StartTaskResult;
import cn.ponfee.disjob.core.dto.worker.SplitJobParam;
import cn.ponfee.disjob.core.dto.worker.VerifyJobParam;
import cn.ponfee.disjob.core.enums.JobType;
import cn.ponfee.disjob.core.enums.RouteStrategy;
import cn.ponfee.disjob.core.enums.RunState;
import cn.ponfee.disjob.core.enums.RunType;
import cn.ponfee.disjob.supervisor.model.SchedInstance;
import cn.ponfee.disjob.supervisor.model.SchedJob;
import cn.ponfee.disjob.supervisor.model.SchedTask;
import cn.ponfee.disjob.supervisor.model.SchedWorkflow;
import java.util.Date;
import java.util.List;
import org.springframework.util.Assert;

public final class ModelConverter {
    public static PredecessorInstance toPredecessorInstance(SchedWorkflow workflow, List<SchedTask> tasks) {
        PredecessorInstance instance = new PredecessorInstance();
        instance.setInstanceId(workflow.getInstanceId().longValue());
        instance.setCurNode(workflow.getCurNode());
        instance.setTasks(Collects.convert(tasks, ModelConverter::toPredecessorTask));
        return instance;
    }

    public static VerifyJobParam toVerifyJobParam(SchedJob job) {
        VerifyJobParam param = new VerifyJobParam();
        param.fillSupervisorAuthenticationToken(job.getGroup());
        param.setJobExecutor(job.getJobExecutor());
        param.setJobParam(job.getJobParam());
        param.setJobType(JobType.of((int)job.getJobType()));
        param.setRouteStrategy(RouteStrategy.of((int)job.getRouteStrategy()));
        param.check();
        return param;
    }

    public static SplitJobParam toSplitJobParam(SchedJob job, SchedInstance instance) {
        Assert.isTrue((boolean)JobType.of((int)job.getJobType()).isGeneral(), (String)"Job must be general.");
        return ModelConverter.toSplitJobParam(job, instance.getRetriedCount(), job.getJobExecutor(), null);
    }

    public static SplitJobParam toSplitJobParam(SchedJob job, SchedInstance instance, List<PredecessorInstance> predecessorInstances) {
        Assert.isTrue((boolean)JobType.of((int)job.getJobType()).isWorkflow(), (String)"Job must be workflow.");
        Assert.isTrue((boolean)instance.isWorkflowNode(), () -> "Split job must be node instance: " + (Object)((Object)instance));
        String curJobExecutor = instance.parseWorkflowCurNode().getName();
        return ModelConverter.toSplitJobParam(job, instance.getRetriedCount(), curJobExecutor, predecessorInstances);
    }

    public static StartTaskResult toStartTaskResult(SchedTask task) {
        StartTaskResult result = new StartTaskResult();
        result.setSuccess(true);
        result.setTaskId(task.getTaskId().longValue());
        result.setTaskNo(task.getTaskNo().intValue());
        result.setTaskCount(task.getTaskCount().intValue());
        result.setExecuteSnapshot(task.getExecuteSnapshot());
        result.setTaskParam(task.getTaskParam());
        return result;
    }

    public static AlertInstanceEvent toAlertInstanceEvent(SchedJob job, SchedInstance original, SchedInstance current) {
        AlertType alertType;
        AlertType alertType2 = alertType = original.isCompleted() ? AlertType.NOTICE : AlertType.ALARM;
        if (!alertType.matches(job.getAlertOptions())) {
            return null;
        }
        AlertInstanceEvent event = new AlertInstanceEvent();
        event.setGroup(job.getGroup());
        event.setJobName(job.getJobName());
        event.setJobId(job.getJobId().longValue());
        event.setAlertType(alertType);
        event.setInstanceId(original.getInstanceId().longValue());
        event.setRunType(RunType.of((int)original.getRunType()));
        event.setRunState(RunState.of((int)original.getRunState()));
        event.setTriggerTime(new Date(original.getTriggerTime()));
        event.setRunStartTime(original.getRunStartTime());
        event.setRunEndTime(current.getRunEndTime());
        event.setRetriedCount(current.getRetriedCount().intValue());
        return event;
    }

    private static PredecessorTask toPredecessorTask(SchedTask source) {
        PredecessorTask target = new PredecessorTask();
        target.setTaskId(source.getTaskId().longValue());
        target.setTaskNo(source.getTaskNo().intValue());
        target.setTaskCount(source.getTaskCount().intValue());
        target.setExecuteSnapshot(source.getExecuteSnapshot());
        return target;
    }

    private static SplitJobParam toSplitJobParam(SchedJob job, int retriedCount, String jobExecutor, List<PredecessorInstance> predecessorInstances) {
        SplitJobParam param = new SplitJobParam();
        param.fillSupervisorAuthenticationToken(job.getGroup());
        param.setJobExecutor(jobExecutor);
        param.setJobParam(job.getJobParam());
        param.setRetryCount(job.getRetryCount().intValue());
        param.setRetriedCount(retriedCount);
        param.setJobType(JobType.of((int)job.getJobType()));
        param.setRouteStrategy(RouteStrategy.of((int)job.getRouteStrategy()));
        param.setPredecessorInstances(predecessorInstances);
        param.check();
        return param;
    }
}

