/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.base;

import cn.ponfee.disjob.common.date.Dates;
import cn.ponfee.disjob.core.enums.MisfireStrategy;
import cn.ponfee.disjob.core.enums.TriggerType;
import cn.ponfee.disjob.supervisor.model.SchedJob;
import java.util.Date;
import org.springframework.util.Assert;

public final class TriggerTimes {
    public static Long updateNextTriggerTime(SchedJob job) {
        Long lastTriggerTime = job.getLastTriggerTime();
        Date now = new Date();
        job.setLastTriggerTime(Long.max(now.getTime() - 1L, lastTriggerTime == null ? 0L : lastTriggerTime));
        Long next = TriggerTimes.computeNextTriggerTime(job, now);
        Assert.notNull((Object)next, () -> "Expire " + TriggerType.of((int)job.getTriggerType()) + " value: " + job.getTriggerValue());
        job.setLastTriggerTime(lastTriggerTime);
        return next;
    }

    public static Long computeNextTriggerTime(SchedJob job, Date now) {
        Assert.notNull((Object)now, (String)"Compute next trigger time 'now' cannot be null.");
        Date last = Dates.ofTimeMillis((Long)job.getLastTriggerTime());
        Date next = TriggerTimes.computeNextTriggerTime0(job, last, now);
        if (last != null && next != null && !next.after(last)) {
            throw new IllegalStateException("Next trigger time must be after last: " + last + ", " + last);
        }
        Date end = job.getEndTime();
        return next == null || end != null && next.after(end) ? null : Long.valueOf(next.getTime());
    }

    private static Date computeNextTriggerTime0(SchedJob job, Date last, Date now) {
        Date next;
        TriggerType type;
        if (job == null || TriggerType.DEPEND == (type = TriggerType.of((int)job.getTriggerType()))) {
            return null;
        }
        MisfireStrategy strategy = MisfireStrategy.of((int)job.getMisfireStrategy());
        String value = job.getTriggerValue();
        Date start = job.getStartTime();
        Date max = Dates.max((Date)start, (Date)last, (Date)now);
        if (type == TriggerType.ONCE) {
            Date next2 = type.computeNextTriggerTime(value, new Date(-1L));
            boolean isInvalid = next2 == null || start != null && next2.before(start) || last != null && !next2.after(last) || strategy == MisfireStrategy.SKIP_ALL_LOST && next2.before(max);
            return isInvalid ? null : next2;
        }
        if (max.equals(start) && !start.equals(last)) {
            return type.computeFirstTriggerTime(value, start);
        }
        if (last == null) {
            Date next3 = type.computeNextTriggerTime(value, max);
            if (strategy == MisfireStrategy.SKIP_ALL_LOST || next3 != null) {
                return next3;
            }
            next3 = type.computeFirstTriggerTime(value, start != null ? start : new Date(-1L));
            if (next3 == null || start != null && next3.before(start)) {
                return null;
            }
            if (strategy == MisfireStrategy.FIRE_ALL_LOST) {
                return next3;
            }
            Date afterNext = type.computeNextTriggerTime(value, next3);
            return afterNext == null || afterNext.after(max) ? next3 : max;
        }
        Date date = next = start != null && last.before(start) ? type.computeFirstTriggerTime(value, start) : type.computeNextTriggerTime(value, last);
        if (next == null || !next.before(max)) {
            return next;
        }
        if (strategy == MisfireStrategy.FIRE_ALL_LOST) {
            return next;
        }
        if (strategy == MisfireStrategy.FIRE_ONCE_NOW) {
            Date afterNext = type.computeNextTriggerTime(value, next);
            return afterNext == null || afterNext.after(max) ? next : max;
        }
        if (strategy == MisfireStrategy.SKIP_ALL_LOST) {
            return type.computeNextTriggerTime(value, max);
        }
        throw new UnsupportedOperationException("Unsupported compute next trigger time: " + type);
    }
}

