/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.component;

import cn.ponfee.disjob.common.model.PageResponse;
import cn.ponfee.disjob.common.util.Numbers;
import cn.ponfee.disjob.core.enums.RunState;
import cn.ponfee.disjob.core.enums.RunType;
import cn.ponfee.disjob.supervisor.application.converter.SchedJobConverter;
import cn.ponfee.disjob.supervisor.application.request.SchedInstancePageRequest;
import cn.ponfee.disjob.supervisor.application.request.SchedJobPageRequest;
import cn.ponfee.disjob.supervisor.application.request.SchedJobSearchRequest;
import cn.ponfee.disjob.supervisor.application.response.SchedInstanceResponse;
import cn.ponfee.disjob.supervisor.application.response.SchedJobResponse;
import cn.ponfee.disjob.supervisor.dao.mapper.SchedInstanceMapper;
import cn.ponfee.disjob.supervisor.dao.mapper.SchedJobMapper;
import cn.ponfee.disjob.supervisor.dao.mapper.SchedTaskMapper;
import cn.ponfee.disjob.supervisor.model.SchedInstance;
import cn.ponfee.disjob.supervisor.model.SchedJob;
import cn.ponfee.disjob.supervisor.model.SchedTask;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class JobQuerier {
    private final SchedJobMapper jobMapper;
    private final SchedInstanceMapper instanceMapper;
    private final SchedTaskMapper taskMapper;

    public SchedJob getJob(long jobId) {
        return this.jobMapper.get(jobId);
    }

    public String getJobGroup(long jobId) {
        return this.jobMapper.getGroup(jobId);
    }

    public SchedInstance getInstance(long instanceId) {
        return this.instanceMapper.get(instanceId);
    }

    public Long getInstanceJobId(long instanceId) {
        return this.instanceMapper.getJobId(instanceId);
    }

    public SchedInstance getInstance(long jobId, long triggerTime, RunType runType) {
        Assert.isTrue((boolean)runType.isUniqueFlag(), () -> "Run type unsupported unique flag: " + runType);
        return this.instanceMapper.getByUniqueKey(jobId, triggerTime, runType.value(), runType.getUniqueFlag());
    }

    public List<SchedJob> findBeTriggeringJob(long maxNextTriggerTime, int size) {
        return this.jobMapper.findBeTriggering(maxNextTriggerTime, size);
    }

    public List<SchedInstance> findExpireWaitingInstance(Date expireTime, int size) {
        return this.instanceMapper.findExpireState(RunState.WAITING.value(), expireTime, size);
    }

    public List<SchedInstance> findExpireRunningInstance(Date expireTime, int size) {
        return this.instanceMapper.findExpireState(RunState.RUNNING.value(), expireTime, size);
    }

    public SchedInstance getRetryingInstance(long instanceId) {
        return this.instanceMapper.getRetrying(instanceId);
    }

    public List<SchedTask> findBaseInstanceTasks(long instanceId) {
        return this.taskMapper.findBaseByInstanceId(instanceId);
    }

    public List<SchedTask> findLargeInstanceTasks(long instanceId) {
        return this.taskMapper.findLargeByInstanceId(instanceId);
    }

    public PageResponse<SchedJobResponse> queryJobForPage(SchedJobPageRequest pageRequest) {
        return pageRequest.query(this.jobMapper::queryPageCount, this.jobMapper::queryPageRecords, SchedJobConverter.INSTANCE::convert);
    }

    public PageResponse<SchedInstanceResponse> queryInstanceForPage(SchedInstancePageRequest pageRequest) {
        PageResponse pageResponse = pageRequest.query(this.instanceMapper::queryPageCount, this.instanceMapper::queryPageRecords, SchedJobConverter.INSTANCE::convert);
        if (pageRequest.isTree()) {
            if (pageRequest.getInstanceId() != null) {
                pageResponse.forEachRow(e -> e.setPnstanceId(null));
            }
            this.fillIsTreeLeaf(pageResponse.getRows());
        }
        return pageResponse;
    }

    public List<SchedInstanceResponse> listInstanceChildren(long pnstanceId) {
        List<SchedInstanceResponse> rows = this.instanceMapper.queryByPnstanceId(pnstanceId).stream().map(SchedJobConverter.INSTANCE::convert).collect(Collectors.toList());
        this.fillIsTreeLeaf(rows);
        return rows;
    }

    public List<Map<String, Object>> searchJob(SchedJobSearchRequest req) {
        return this.jobMapper.searchJob(req.getGroups(), req.getJobName(), req.getJobId());
    }

    private void fillIsTreeLeaf(List<SchedInstanceResponse> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List<Long> instanceIds = list.stream().map(SchedInstanceResponse::getInstanceId).collect(Collectors.toList());
        Map<Long, Integer> map = this.instanceMapper.queryChildCount(instanceIds).stream().collect(Collectors.toMap(e -> MapUtils.getLongValue((Map)e, (Object)"pnstanceId"), e -> MapUtils.getIntValue((Map)e, (Object)"count")));
        Iterator<SchedInstanceResponse> iterator = list.iterator();
        while (iterator.hasNext()) {
            SchedInstanceResponse e2;
            Integer count = map.get((e2 = iterator.next()).getInstanceId());
            e2.setIsTreeLeaf(Numbers.isNullOrZero((Integer)count) ? 0 : 1);
        }
    }

    public JobQuerier(SchedJobMapper jobMapper, SchedInstanceMapper instanceMapper, SchedTaskMapper taskMapper) {
        this.jobMapper = jobMapper;
        this.instanceMapper = instanceMapper;
        this.taskMapper = taskMapper;
    }
}

