/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.configuration;

import cn.ponfee.disjob.common.spring.SpringUtils;
import cn.ponfee.disjob.common.util.ClassUtils;
import cn.ponfee.disjob.common.util.Strings;
import cn.ponfee.disjob.core.base.BasicDeferredImportSelector;
import cn.ponfee.disjob.core.base.CoreUtils;
import cn.ponfee.disjob.core.base.GroupInfoService;
import cn.ponfee.disjob.core.base.Supervisor;
import cn.ponfee.disjob.supervisor.SupervisorStartup;
import cn.ponfee.disjob.supervisor.configuration.SupervisorDeferredImportSelector;
import cn.ponfee.disjob.supervisor.configuration.SupervisorLifecycle;
import cn.ponfee.disjob.supervisor.configuration.SupervisorProperties;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.context.WebServerApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Documented
@Import(value={EnableSupervisorConfiguration.class, BasicDeferredImportSelector.class, SupervisorDeferredImportSelector.class, SupervisorLifecycle.class})
public @interface EnableSupervisor {

    @EnableConfigurationProperties(value={SupervisorProperties.class})
    @ComponentScan(basePackageClasses={SupervisorStartup.class})
    public static class EnableSupervisorConfiguration {
        @Bean
        public Supervisor.Local localSupervisor(WebServerApplicationContext webServerApplicationContext, ServerProperties serverProperties, GroupInfoService groupInfoService) {
            int port = SpringUtils.getWebServerPort((WebServerApplicationContext)webServerApplicationContext);
            String contextPath = Strings.trimPath((String)serverProperties.getServlet().getContextPath());
            Object[] args = new Object[]{CoreUtils.getLocalHost(), port, contextPath, groupInfoService};
            try {
                return (Supervisor.Local)ClassUtils.invoke(Supervisor.Local.class, (String)"create", (Object[])args);
            }
            catch (Exception e) {
                throw new Error("Creates Supervisor.Local instance occur error.", e);
            }
        }
    }
}

