/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.configuration;

import cn.ponfee.disjob.alert.Alerter;
import cn.ponfee.disjob.alert.base.AlerterProperties;
import cn.ponfee.disjob.alert.sender.AlertSender;
import cn.ponfee.disjob.common.lock.DatabaseLockTemplate;
import cn.ponfee.disjob.common.lock.LockTemplate;
import cn.ponfee.disjob.core.base.GroupInfoService;
import cn.ponfee.disjob.supervisor.base.DefaultGroupInfoService;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.jdbc.core.JdbcTemplate;

class SupervisorDeferredImportSelector
implements DeferredImportSelector {
    SupervisorDeferredImportSelector() {
    }

    public String[] selectImports(AnnotationMetadata importingClassMetadata) {
        return new String[]{SupervisorDeferredConfiguration.class.getName()};
    }

    private static class SupervisorDeferredConfiguration {
        private SupervisorDeferredConfiguration() {
        }

        @ConditionalOnMissingBean
        @Bean
        public GroupInfoService groupInfoService() {
            return DefaultGroupInfoService.INSTANCE;
        }

        @ConditionalOnMissingBean(name={"disjob.bean.scan-waiting-instance-locker"})
        @Bean(value={"disjob.bean.scan-waiting-instance-locker"})
        public LockTemplate scanWaitingInstanceLocker(@Qualifier(value="disjobJdbcTemplate") JdbcTemplate jdbcTemplate) {
            return new DatabaseLockTemplate(jdbcTemplate, "waiting_instance");
        }

        @ConditionalOnMissingBean(name={"disjob.bean.scan-running-instance-locker"})
        @Bean(value={"disjob.bean.scan-running-instance-locker"})
        public LockTemplate scanRunningInstanceLocker(@Qualifier(value="disjobJdbcTemplate") JdbcTemplate jdbcTemplate) {
            return new DatabaseLockTemplate(jdbcTemplate, "running_instance");
        }

        @ConditionalOnMissingBean(name={"disjob.bean.scan-triggering-job-locker"})
        @Bean(value={"disjob.bean.scan-triggering-job-locker"})
        public LockTemplate scanTriggeringJobLocker(@Qualifier(value="disjobJdbcTemplate") JdbcTemplate jdbcTemplate) {
            return new DatabaseLockTemplate(jdbcTemplate, "triggering_job");
        }

        @ConditionalOnExpression(value="${disjob.alert.enabled:true}")
        @ConditionalOnBean(value={AlertSender.class})
        @Bean
        public AlerterProperties alerterProperties() {
            return new AlerterProperties();
        }

        @ConditionalOnExpression(value="${disjob.alert.enabled:true}")
        @ConditionalOnBean(value={AlertSender.class})
        @Bean
        public Alerter alerter(AlerterProperties alerterConfig, GroupInfoService groupInfoService) {
            return new Alerter(alerterConfig, groupInfoService);
        }
    }
}

