/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.configuration;

import cn.ponfee.disjob.common.lock.LockTemplate;
import cn.ponfee.disjob.core.base.Supervisor;
import cn.ponfee.disjob.dispatch.TaskDispatcher;
import cn.ponfee.disjob.registry.SupervisorRegistry;
import cn.ponfee.disjob.supervisor.SupervisorStartup;
import cn.ponfee.disjob.supervisor.component.JobManager;
import cn.ponfee.disjob.supervisor.component.JobQuerier;
import cn.ponfee.disjob.supervisor.component.WorkerClient;
import cn.ponfee.disjob.supervisor.configuration.SupervisorProperties;
import cn.ponfee.disjob.supervisor.scanner.RunningInstanceScanner;
import cn.ponfee.disjob.supervisor.scanner.TriggeringJobScanner;
import cn.ponfee.disjob.supervisor.scanner.WaitingInstanceScanner;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.SmartLifecycle;

class SupervisorLifecycle
implements SmartLifecycle {
    private final SupervisorStartup supervisorStartup;

    SupervisorLifecycle(Supervisor.Local localSupervisor, SupervisorRegistry supervisorRegistry, TaskDispatcher taskDispatcher, SupervisorProperties supervisorConf, JobManager jobManager, JobQuerier jobQuerier, WorkerClient workerClient, @Qualifier(value="disjob.bean.scan-waiting-instance-locker") LockTemplate scanWaitingInstanceLocker, @Qualifier(value="disjob.bean.scan-running-instance-locker") LockTemplate scanRunningInstanceLocker, @Qualifier(value="disjob.bean.scan-triggering-job-locker") LockTemplate scanTriggeringJobLocker) {
        supervisorConf.check();
        this.supervisorStartup = new SupervisorStartup(localSupervisor, supervisorConf, supervisorRegistry, taskDispatcher, new WaitingInstanceScanner(supervisorConf, jobManager, jobQuerier, workerClient, scanWaitingInstanceLocker), new RunningInstanceScanner(supervisorConf, jobManager, jobQuerier, workerClient, scanRunningInstanceLocker), new TriggeringJobScanner(supervisorConf, jobManager, jobQuerier, workerClient, scanTriggeringJobLocker));
    }

    public void start() {
        this.supervisorStartup.start();
    }

    public void stop(Runnable callback) {
        this.supervisorStartup.stop();
        callback.run();
    }

    public void stop() {
        this.stop(() -> {});
    }

    public boolean isRunning() {
        return this.supervisorStartup.isRunning();
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }
}

