/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.configuration;

import cn.ponfee.disjob.common.base.ToJsonString;
import java.io.Serializable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(prefix="disjob.supervisor")
public class SupervisorProperties
extends ToJsonString
implements Serializable {
    private static final long serialVersionUID = -7896732123210543684L;
    private boolean printBannerEnabled = true;
    private int scanBatchSize = 200;
    private int maximumSplitTaskSize = 1000;
    private int maximumJobDependsDepth = 20;
    private int maximumJobRetryCount = 5;
    private long scanTriggeringJobPeriodMs = 3000L;
    private long scanWaitingInstancePeriodMs = 15000L;
    private long scanRunningInstancePeriodMs = 30000L;
    private long shutdownTaskDelayResumeMs = 600000L;
    private int maximumProcessJobPoolSize = 10;
    private int groupRefreshPeriodMinutes = 0;
    private int jobScanFailedCountThreshold = 5;
    private int taskDispatchFailedCountThreshold = 3;

    public void check() {
        Assert.isTrue((20 <= this.scanBatchSize && this.scanBatchSize <= 2000 ? 1 : 0) != 0, (String)"Scan batch size must be range [20, 2000].");
        Assert.isTrue((this.maximumSplitTaskSize > 0 ? 1 : 0) != 0, (String)"Maximum split task size must be greater than 0.");
        Assert.isTrue((0 < this.maximumJobDependsDepth && this.maximumJobDependsDepth < 100 ? 1 : 0) != 0, (String)"Maximum job depends depth must be range [1, 99].");
        Assert.isTrue((0 < this.maximumJobRetryCount && this.maximumJobRetryCount < 10 ? 1 : 0) != 0, (String)"Maximum job retry count must be range [1, 9].");
        Assert.isTrue((this.scanTriggeringJobPeriodMs >= 1000L ? 1 : 0) != 0, (String)"Scan triggering job period ms cannot less than 1000.");
        Assert.isTrue((this.scanWaitingInstancePeriodMs >= 15000L ? 1 : 0) != 0, (String)"Scan waiting instance period ms cannot less than 15000.");
        Assert.isTrue((this.scanRunningInstancePeriodMs >= 30000L ? 1 : 0) != 0, (String)"Scan running instance period ms cannot less than 30000.");
        Assert.isTrue((this.shutdownTaskDelayResumeMs >= 60000L ? 1 : 0) != 0, (String)"Shutdown task delay resume ms cannot less than 60000.");
        Assert.isTrue((this.maximumProcessJobPoolSize > 0 ? 1 : 0) != 0, (String)"Maximum process job pool size must be greater than 0.");
        Assert.isTrue((this.groupRefreshPeriodMinutes >= 0 ? 1 : 0) != 0, (String)"Refresh group period minutes cannot less than 0.");
        Assert.isTrue((this.jobScanFailedCountThreshold >= 0 ? 1 : 0) != 0, (String)"Job scan failed count threshold cannot less than 0.");
        Assert.isTrue((this.taskDispatchFailedCountThreshold >= 0 ? 1 : 0) != 0, (String)"Task dispatch failed count threshold cannot less than 0.");
    }

    public boolean isPrintBannerEnabled() {
        return this.printBannerEnabled;
    }

    public int getScanBatchSize() {
        return this.scanBatchSize;
    }

    public int getMaximumSplitTaskSize() {
        return this.maximumSplitTaskSize;
    }

    public int getMaximumJobDependsDepth() {
        return this.maximumJobDependsDepth;
    }

    public int getMaximumJobRetryCount() {
        return this.maximumJobRetryCount;
    }

    public long getScanTriggeringJobPeriodMs() {
        return this.scanTriggeringJobPeriodMs;
    }

    public long getScanWaitingInstancePeriodMs() {
        return this.scanWaitingInstancePeriodMs;
    }

    public long getScanRunningInstancePeriodMs() {
        return this.scanRunningInstancePeriodMs;
    }

    public long getShutdownTaskDelayResumeMs() {
        return this.shutdownTaskDelayResumeMs;
    }

    public int getMaximumProcessJobPoolSize() {
        return this.maximumProcessJobPoolSize;
    }

    public int getGroupRefreshPeriodMinutes() {
        return this.groupRefreshPeriodMinutes;
    }

    public int getJobScanFailedCountThreshold() {
        return this.jobScanFailedCountThreshold;
    }

    public int getTaskDispatchFailedCountThreshold() {
        return this.taskDispatchFailedCountThreshold;
    }

    public void setPrintBannerEnabled(boolean printBannerEnabled) {
        this.printBannerEnabled = printBannerEnabled;
    }

    public void setScanBatchSize(int scanBatchSize) {
        this.scanBatchSize = scanBatchSize;
    }

    public void setMaximumSplitTaskSize(int maximumSplitTaskSize) {
        this.maximumSplitTaskSize = maximumSplitTaskSize;
    }

    public void setMaximumJobDependsDepth(int maximumJobDependsDepth) {
        this.maximumJobDependsDepth = maximumJobDependsDepth;
    }

    public void setMaximumJobRetryCount(int maximumJobRetryCount) {
        this.maximumJobRetryCount = maximumJobRetryCount;
    }

    public void setScanTriggeringJobPeriodMs(long scanTriggeringJobPeriodMs) {
        this.scanTriggeringJobPeriodMs = scanTriggeringJobPeriodMs;
    }

    public void setScanWaitingInstancePeriodMs(long scanWaitingInstancePeriodMs) {
        this.scanWaitingInstancePeriodMs = scanWaitingInstancePeriodMs;
    }

    public void setScanRunningInstancePeriodMs(long scanRunningInstancePeriodMs) {
        this.scanRunningInstancePeriodMs = scanRunningInstancePeriodMs;
    }

    public void setShutdownTaskDelayResumeMs(long shutdownTaskDelayResumeMs) {
        this.shutdownTaskDelayResumeMs = shutdownTaskDelayResumeMs;
    }

    public void setMaximumProcessJobPoolSize(int maximumProcessJobPoolSize) {
        this.maximumProcessJobPoolSize = maximumProcessJobPoolSize;
    }

    public void setGroupRefreshPeriodMinutes(int groupRefreshPeriodMinutes) {
        this.groupRefreshPeriodMinutes = groupRefreshPeriodMinutes;
    }

    public void setJobScanFailedCountThreshold(int jobScanFailedCountThreshold) {
        this.jobScanFailedCountThreshold = jobScanFailedCountThreshold;
    }

    public void setTaskDispatchFailedCountThreshold(int taskDispatchFailedCountThreshold) {
        this.taskDispatchFailedCountThreshold = taskDispatchFailedCountThreshold;
    }
}

