/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.dag;

import cn.ponfee.disjob.common.dag.DAGExpression;
import cn.ponfee.disjob.common.dag.DAGNode;
import com.google.common.graph.EndpointPair;
import guru.nidi.graphviz.attribute.Attributes;
import guru.nidi.graphviz.attribute.GraphAttr;
import guru.nidi.graphviz.attribute.Label;
import guru.nidi.graphviz.attribute.Rank;
import guru.nidi.graphviz.attribute.Shape;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.model.Factory;
import guru.nidi.graphviz.model.LinkSource;
import guru.nidi.graphviz.model.LinkTarget;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.model.Node;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.commons.lang3.mutable.MutableInt;

public class DAGUtils {
    public static void drawImage(String expression, boolean thumb, int width, OutputStream output) throws IOException {
        DAGUtils.drawImage(expression, thumb, "PNG", width, output);
    }

    public static void drawImage(String expression, boolean thumb, String format, int width, OutputStream output) throws IOException {
        MutableGraph graph = Factory.mutGraph().setDirected(true);
        graph.graphAttrs().add((Attributes)Rank.dir((Rank.RankDir)Rank.RankDir.LEFT_TO_RIGHT));
        graph.graphAttrs().add(GraphAttr.splines((GraphAttr.SplineMode)GraphAttr.SplineMode.CURVED));
        MutableInt begin = new MutableInt(65);
        HashMap<String, String> map = new HashMap<String, String>();
        for (EndpointPair edge : DAGExpression.parse((String)expression).edges()) {
            DAGNode sn = (DAGNode)edge.source();
            DAGNode tn = (DAGNode)edge.target();
            String sl = sn.getName();
            String tl = tn.getName();
            if (thumb) {
                if (!sn.isStartOrEnd()) {
                    sl = map.computeIfAbsent(sl, k -> String.valueOf((char)begin.getAndIncrement()));
                }
                if (!tn.isStartOrEnd()) {
                    tl = map.computeIfAbsent(tl, k -> String.valueOf((char)begin.getAndIncrement()));
                }
            }
            Node source = (Node)Factory.node((String)sn.toString()).with((Attributes)(sn.isStart() ? Shape.M_DIAMOND : Shape.RECTANGLE), (Attributes)Label.of((String)sl));
            Node target = (Node)Factory.node((String)tn.toString()).with((Attributes)(tn.isEnd() ? Shape.M_SQUARE : Shape.RECTANGLE), (Attributes)Label.of((String)tl));
            graph.add((LinkSource)source.link(new LinkTarget[]{target}));
        }
        Graphviz.fromGraph((MutableGraph)graph).width(width).render(Format.valueOf((String)format)).toOutputStream(output);
    }
}

