/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.dag;

import cn.ponfee.disjob.common.dag.DAGEdge;
import cn.ponfee.disjob.common.dag.DAGNode;
import cn.ponfee.disjob.supervisor.model.SchedWorkflow;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class WorkflowGraph {
    private final Map<DAGEdge, SchedWorkflow> map;
    private final Graph<DAGNode> graph;

    private WorkflowGraph(List<SchedWorkflow> workflows) {
        this.map = WorkflowGraph.buildMap(workflows);
        this.graph = WorkflowGraph.buildGraph(workflows);
    }

    public static WorkflowGraph of(List<SchedWorkflow> workflows) {
        return new WorkflowGraph(workflows);
    }

    public Map<DAGEdge, SchedWorkflow> predecessors(DAGNode node) {
        return this.find(this.graph.predecessors((Object)node));
    }

    public Map<DAGEdge, SchedWorkflow> successors(DAGNode node) {
        return this.find(this.graph.successors((Object)node));
    }

    public Map<DAGEdge, SchedWorkflow> map() {
        return this.map;
    }

    public SchedWorkflow get(DAGNode source, DAGNode target) {
        return this.map.get(new DAGEdge(source, target));
    }

    public boolean allMatch(Predicate<Map.Entry<DAGEdge, SchedWorkflow>> predicate) {
        return this.map.entrySet().stream().allMatch(predicate);
    }

    public boolean anyMatch(Predicate<Map.Entry<DAGEdge, SchedWorkflow>> predicate) {
        return this.map.entrySet().stream().anyMatch(predicate);
    }

    private Map<DAGEdge, SchedWorkflow> find(Set<DAGNode> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return Collections.emptyMap();
        }
        return this.map.entrySet().stream().filter(e -> nodes.contains(((DAGEdge)e.getKey()).getTarget())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map<DAGEdge, SchedWorkflow> buildMap(List<SchedWorkflow> workflows) {
        return Collections.unmodifiableMap(workflows.stream().collect(Collectors.toMap(SchedWorkflow::toEdge, Function.identity())));
    }

    private static Graph<DAGNode> buildGraph(List<SchedWorkflow> workflows) {
        ImmutableGraph.Builder builder = GraphBuilder.directed().allowsSelfLoops(false).immutable();
        for (SchedWorkflow edge : workflows) {
            builder.putEdge((Object)edge.parsePreNode(), (Object)edge.parseCurNode());
        }
        return builder.build();
    }
}

