/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.instance;

import cn.ponfee.disjob.common.base.TriConsumer;
import cn.ponfee.disjob.core.enums.RunType;
import cn.ponfee.disjob.core.exception.JobException;
import cn.ponfee.disjob.supervisor.base.ModelConverter;
import cn.ponfee.disjob.supervisor.component.JobManager;
import cn.ponfee.disjob.supervisor.instance.TriggerInstance;
import cn.ponfee.disjob.supervisor.model.SchedInstance;
import cn.ponfee.disjob.supervisor.model.SchedJob;
import cn.ponfee.disjob.supervisor.model.SchedTask;
import cn.ponfee.disjob.supervisor.model.SchedWorkflow;
import java.util.Collections;
import java.util.List;

class GeneralInstance
extends TriggerInstance {
    private List<SchedTask> tasks;

    GeneralInstance(JobManager jobManager, SchedJob job) {
        super(jobManager, job);
    }

    @Override
    void create(SchedInstance parent, RunType runType, long triggerTime) throws JobException {
        long instanceId = this.jobManager.generateId();
        this.instance = SchedInstance.of(parent, null, instanceId, this.job.getJobId(), runType, triggerTime, 0);
        this.tasks = this.jobManager.splitJob(this.job.getGroup(), instanceId, ModelConverter.toSplitJobParam(this.job, this.instance));
    }

    @Override
    public void save(TriConsumer<List<SchedInstance>, List<SchedWorkflow>, List<SchedTask>> persistence) {
        persistence.accept(Collections.singletonList(this.instance), null, this.tasks);
    }

    @Override
    public void dispatch(TriConsumer<SchedJob, SchedInstance, List<SchedTask>> dispatching) {
        dispatching.accept((Object)this.job, (Object)this.instance, this.tasks);
    }
}

