/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.instance;

import cn.ponfee.disjob.common.base.TriConsumer;
import cn.ponfee.disjob.core.enums.JobType;
import cn.ponfee.disjob.core.enums.RunType;
import cn.ponfee.disjob.core.exception.JobException;
import cn.ponfee.disjob.supervisor.component.JobManager;
import cn.ponfee.disjob.supervisor.instance.GeneralInstance;
import cn.ponfee.disjob.supervisor.instance.WorkflowInstance;
import cn.ponfee.disjob.supervisor.model.SchedInstance;
import cn.ponfee.disjob.supervisor.model.SchedJob;
import cn.ponfee.disjob.supervisor.model.SchedTask;
import cn.ponfee.disjob.supervisor.model.SchedWorkflow;
import java.util.List;

public abstract class TriggerInstance {
    protected final JobManager jobManager;
    protected final SchedJob job;
    protected SchedInstance instance;

    TriggerInstance(JobManager jobManager, SchedJob job) {
        this.jobManager = jobManager;
        this.job = job;
    }

    abstract void create(SchedInstance var1, RunType var2, long var3) throws JobException;

    public abstract void save(TriConsumer<List<SchedInstance>, List<SchedWorkflow>, List<SchedTask>> var1);

    public abstract void dispatch(TriConsumer<SchedJob, SchedInstance, List<SchedTask>> var1);

    public static TriggerInstance of(JobManager jobManager, SchedJob job, SchedInstance parent, RunType runType, long triggerTime) throws JobException {
        TriggerInstance triggerInstance;
        JobType jobType = JobType.of((int)job.getJobType());
        switch (jobType) {
            case GENERAL: {
                triggerInstance = new GeneralInstance(jobManager, job);
                break;
            }
            case WORKFLOW: {
                triggerInstance = new WorkflowInstance(jobManager, job);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown job type: " + jobType);
            }
        }
        triggerInstance.create(parent, runType, triggerTime);
        return triggerInstance;
    }
}

