/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.instance;

import cn.ponfee.disjob.common.base.TriConsumer;
import cn.ponfee.disjob.common.collect.Collects;
import cn.ponfee.disjob.common.dag.DAGEdge;
import cn.ponfee.disjob.common.dag.DAGExpression;
import cn.ponfee.disjob.common.dag.DAGNode;
import cn.ponfee.disjob.common.date.Dates;
import cn.ponfee.disjob.common.tuple.Tuple2;
import cn.ponfee.disjob.core.dto.worker.SplitJobParam;
import cn.ponfee.disjob.core.enums.RunState;
import cn.ponfee.disjob.core.enums.RunType;
import cn.ponfee.disjob.core.exception.JobException;
import cn.ponfee.disjob.supervisor.base.ModelConverter;
import cn.ponfee.disjob.supervisor.component.JobManager;
import cn.ponfee.disjob.supervisor.dag.WorkflowGraph;
import cn.ponfee.disjob.supervisor.instance.TriggerInstance;
import cn.ponfee.disjob.supervisor.model.SchedInstance;
import cn.ponfee.disjob.supervisor.model.SchedJob;
import cn.ponfee.disjob.supervisor.model.SchedTask;
import cn.ponfee.disjob.supervisor.model.SchedWorkflow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class WorkflowInstance
extends TriggerInstance {
    private List<SchedWorkflow> workflows;
    private List<Tuple2<SchedInstance, List<SchedTask>>> nodes;

    WorkflowInstance(JobManager jobManager, SchedJob job) {
        super(jobManager, job);
    }

    @Override
    void create(SchedInstance parent, RunType runType, long triggerTime) throws JobException {
        long wnstanceId = this.jobManager.generateId();
        long jobId = this.job.getJobId();
        SchedInstance leadInstance = SchedInstance.of(parent, wnstanceId, wnstanceId, jobId, runType, triggerTime, 0);
        leadInstance.setRunState(RunState.RUNNING.value());
        leadInstance.setRunStartTime(Dates.max((Date)new Date(), (Date)new Date(triggerTime)));
        this.instance = leadInstance;
        this.workflows = DAGExpression.parse((String)this.job.getJobExecutor()).edges().stream().map(e -> SchedWorkflow.of(wnstanceId, ((DAGNode)e.source()).toString(), ((DAGNode)e.target()).toString())).collect(Collectors.toList());
        this.nodes = new ArrayList<Tuple2<SchedInstance, List<SchedTask>>>();
        for (Map.Entry<DAGEdge, SchedWorkflow> each : WorkflowGraph.of(this.workflows).successors(DAGNode.START).entrySet()) {
            DAGNode node = each.getKey().getTarget();
            SchedWorkflow workflow = each.getValue();
            long nodeInstanceId = this.jobManager.generateId();
            workflow.setInstanceId(nodeInstanceId);
            workflow.setRunState(RunState.RUNNING.value());
            SchedInstance nodeInstance = SchedInstance.of(leadInstance, nodeInstanceId, jobId, runType, triggerTime, 0);
            nodeInstance.setWorkflowCurNode(node.toString());
            SplitJobParam param = ModelConverter.toSplitJobParam(this.job, nodeInstance, null);
            List<SchedTask> nodeTasks = this.jobManager.splitJob(this.job.getGroup(), nodeInstance.getInstanceId(), param);
            this.nodes.add((Tuple2<SchedInstance, List<SchedTask>>)Tuple2.of((Object)((Object)nodeInstance), nodeTasks));
        }
    }

    @Override
    public void save(TriConsumer<List<SchedInstance>, List<SchedWorkflow>, List<SchedTask>> persistence) {
        ArrayList instances = Collects.newArrayList((int)(this.nodes.size() + 1), (Object)((Object)this.instance));
        ArrayList tasks = new ArrayList(this.nodes.stream().mapToInt(e -> ((List)e.b).size()).sum());
        for (Tuple2<SchedInstance, List<SchedTask>> node : this.nodes) {
            instances.add(node.a);
            tasks.addAll((Collection)node.b);
        }
        persistence.accept((Object)instances, this.workflows, tasks);
    }

    @Override
    public void dispatch(TriConsumer<SchedJob, SchedInstance, List<SchedTask>> dispatching) {
        for (Tuple2<SchedInstance, List<SchedTask>> node : this.nodes) {
            dispatching.accept((Object)this.job, node.a, node.b);
        }
    }
}

