/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.model;

import cn.ponfee.disjob.common.model.BaseEntity;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.enums.ExecuteState;
import java.beans.Transient;
import java.util.Comparator;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class SchedTask
extends BaseEntity {
    private static final long serialVersionUID = 4882055618593707631L;
    public static final Comparator<SchedTask> TASK_NO_COMPARATOR = Comparator.comparing(SchedTask::getTaskNo);
    private Long taskId;
    private Long instanceId;
    private Integer taskNo;
    private Integer taskCount;
    private String taskParam;
    private Date executeStartTime;
    private Date executeEndTime;
    private Integer executeState;
    private String executeSnapshot;
    private String worker;
    private Integer dispatchFailedCount;
    private String errorMsg;

    public static SchedTask of(String taskParam, long taskId, long instanceId, int taskNo, int taskCount, String worker) {
        SchedTask task = new SchedTask();
        task.setTaskParam(taskParam == null ? "" : taskParam);
        task.setTaskId(taskId);
        task.setInstanceId(instanceId);
        task.setTaskNo(taskNo);
        task.setTaskCount(taskCount);
        task.setWorker(worker);
        task.setExecuteState(ExecuteState.WAITING.value());
        return task;
    }

    public Worker worker() {
        return StringUtils.isBlank((CharSequence)this.worker) ? null : Worker.deserialize((String)this.worker);
    }

    @Transient
    public boolean isWaiting() {
        return ExecuteState.WAITING.equalsValue(this.executeState);
    }

    @Transient
    public boolean isExecuting() {
        return ExecuteState.EXECUTING.equalsValue(this.executeState);
    }

    @Transient
    public boolean isPausable() {
        return ExecuteState.of((Integer)this.executeState).isPausable();
    }

    @Transient
    public boolean isTerminal() {
        return ExecuteState.of((Integer)this.executeState).isTerminal();
    }

    @Transient
    public boolean isFailure() {
        return ExecuteState.of((Integer)this.executeState).isFailure();
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public Integer getTaskNo() {
        return this.taskNo;
    }

    public Integer getTaskCount() {
        return this.taskCount;
    }

    public String getTaskParam() {
        return this.taskParam;
    }

    public Date getExecuteStartTime() {
        return this.executeStartTime;
    }

    public Date getExecuteEndTime() {
        return this.executeEndTime;
    }

    public Integer getExecuteState() {
        return this.executeState;
    }

    public String getExecuteSnapshot() {
        return this.executeSnapshot;
    }

    public String getWorker() {
        return this.worker;
    }

    public Integer getDispatchFailedCount() {
        return this.dispatchFailedCount;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public void setTaskNo(Integer taskNo) {
        this.taskNo = taskNo;
    }

    public void setTaskCount(Integer taskCount) {
        this.taskCount = taskCount;
    }

    public void setTaskParam(String taskParam) {
        this.taskParam = taskParam;
    }

    public void setExecuteStartTime(Date executeStartTime) {
        this.executeStartTime = executeStartTime;
    }

    public void setExecuteEndTime(Date executeEndTime) {
        this.executeEndTime = executeEndTime;
    }

    public void setExecuteState(Integer executeState) {
        this.executeState = executeState;
    }

    public void setExecuteSnapshot(String executeSnapshot) {
        this.executeSnapshot = executeSnapshot;
    }

    public void setWorker(String worker) {
        this.worker = worker;
    }

    public void setDispatchFailedCount(Integer dispatchFailedCount) {
        this.dispatchFailedCount = dispatchFailedCount;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}

