/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.model;

import cn.ponfee.disjob.common.dag.DAGEdge;
import cn.ponfee.disjob.common.dag.DAGNode;
import cn.ponfee.disjob.common.model.BaseEntity;
import cn.ponfee.disjob.core.enums.RunState;
import java.beans.Transient;

public class SchedWorkflow
extends BaseEntity {
    private static final long serialVersionUID = 3485414559751420216L;
    private Long wnstanceId;
    private String preNode;
    private String curNode;
    private Integer runState;
    private Long instanceId;

    public static SchedWorkflow of(Long wnstanceId, String preNode, String curNode) {
        SchedWorkflow workflow = new SchedWorkflow();
        workflow.setWnstanceId(wnstanceId);
        workflow.setPreNode(preNode);
        workflow.setCurNode(curNode);
        workflow.setRunState(RunState.WAITING.value());
        return workflow;
    }

    public DAGEdge toEdge() {
        return new DAGEdge(DAGNode.fromString((String)this.preNode), DAGNode.fromString((String)this.curNode));
    }

    public DAGNode parsePreNode() {
        return DAGNode.fromString((String)this.preNode);
    }

    public DAGNode parseCurNode() {
        return DAGNode.fromString((String)this.curNode);
    }

    @Transient
    public boolean isTerminal() {
        return RunState.of((int)this.runState).isTerminal();
    }

    @Transient
    public boolean isFailure() {
        return RunState.of((int)this.runState).isFailure();
    }

    @Transient
    public boolean isRunning() {
        return RunState.RUNNING.equalsValue(this.runState);
    }

    @Transient
    public boolean isWaiting() {
        return RunState.WAITING.equalsValue(this.runState);
    }

    @Transient
    public boolean isPaused() {
        return RunState.PAUSED.equalsValue(this.runState);
    }

    public Long getWnstanceId() {
        return this.wnstanceId;
    }

    public String getPreNode() {
        return this.preNode;
    }

    public String getCurNode() {
        return this.curNode;
    }

    public Integer getRunState() {
        return this.runState;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public void setWnstanceId(Long wnstanceId) {
        this.wnstanceId = wnstanceId;
    }

    public void setPreNode(String preNode) {
        this.preNode = preNode;
    }

    public void setCurNode(String curNode) {
        this.curNode = curNode;
    }

    public void setRunState(Integer runState) {
        this.runState = runState;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }
}

