/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.provider;

import cn.ponfee.disjob.common.model.PageResponse;
import cn.ponfee.disjob.common.model.Result;
import cn.ponfee.disjob.common.spring.BaseController;
import cn.ponfee.disjob.core.exception.JobException;
import cn.ponfee.disjob.supervisor.application.AuthorizeGroupService;
import cn.ponfee.disjob.supervisor.application.SchedJobService;
import cn.ponfee.disjob.supervisor.application.request.SchedInstancePageRequest;
import cn.ponfee.disjob.supervisor.application.request.SchedJobAddRequest;
import cn.ponfee.disjob.supervisor.application.request.SchedJobPageRequest;
import cn.ponfee.disjob.supervisor.application.request.SchedJobUpdateRequest;
import cn.ponfee.disjob.supervisor.application.response.SchedInstanceResponse;
import cn.ponfee.disjob.supervisor.application.response.SchedJobResponse;
import cn.ponfee.disjob.supervisor.application.response.SchedTaskResponse;
import cn.ponfee.disjob.supervisor.auth.AuthenticationConfigurer;
import cn.ponfee.disjob.supervisor.auth.SupervisorAuthentication;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/supervisor/openapi"})
@SupervisorAuthentication(value=SupervisorAuthentication.Subject.USER)
public class SupervisorOpenapiProvider
extends BaseController {
    private final SchedJobService schedJobService;
    private final AuthorizeGroupService authorizeGroupService;

    @PostMapping(value={"/job/add"})
    public Result<Long> addJob(@RequestBody SchedJobAddRequest req) throws JobException {
        String user = AuthenticationConfigurer.requestUser();
        AuthorizeGroupService.authorizeGroup(user, AuthenticationConfigurer.requestGroup(), req.getGroup());
        return Result.success((Object)this.schedJobService.addJob(user, req));
    }

    @PutMapping(value={"/job/update"})
    public Result<Void> updateJob(@RequestBody SchedJobUpdateRequest req) throws JobException {
        String user = AuthenticationConfigurer.requestUser();
        AuthorizeGroupService.authorizeGroup(user, AuthenticationConfigurer.requestGroup(), req.getGroup());
        this.schedJobService.updateJob(user, req);
        return Result.success();
    }

    @DeleteMapping(value={"/job/delete"})
    public Result<Void> deleteJob(@RequestParam(value="jobId") long jobId) {
        String user = AuthenticationConfigurer.requestUser();
        this.authorizeGroupService.authorizeJob(user, AuthenticationConfigurer.requestGroup(), jobId);
        this.schedJobService.deleteJob(user, jobId);
        return Result.success();
    }

    @PostMapping(value={"/job/state/change"})
    public Result<Void> changeJobState(@RequestParam(value="jobId") long jobId, @RequestParam(value="jobState") int jobState) {
        String user = AuthenticationConfigurer.requestUser();
        this.authorizeGroupService.authorizeJob(user, AuthenticationConfigurer.requestGroup(), jobId);
        this.schedJobService.changeJobState(user, jobId, jobState);
        return Result.success();
    }

    @PostMapping(value={"/job/trigger"})
    public Result<Void> manualTriggerJob(@RequestParam(value="jobId") long jobId) throws JobException {
        String user = AuthenticationConfigurer.requestUser();
        this.authorizeGroupService.authorizeJob(user, AuthenticationConfigurer.requestGroup(), jobId);
        this.schedJobService.manualTriggerJob(user, jobId);
        return Result.success();
    }

    @GetMapping(value={"/job/get"})
    public Result<SchedJobResponse> getJob(@RequestParam(value="jobId") long jobId) {
        this.authorizeGroupService.authorizeJob(AuthenticationConfigurer.requestUser(), AuthenticationConfigurer.requestGroup(), jobId);
        return Result.success((Object)this.schedJobService.getJob(jobId));
    }

    @GetMapping(value={"/job/page"})
    public Result<PageResponse<SchedJobResponse>> queryJobForPage(SchedJobPageRequest pageRequest) {
        pageRequest.authorizeAndTruncateGroup(AuthenticationConfigurer.requestUser());
        return Result.success(this.schedJobService.queryJobForPage(pageRequest));
    }

    @PostMapping(value={"/instance/pause"})
    public Result<Void> pauseInstance(@RequestParam(value="instanceId") long instanceId) {
        String user = AuthenticationConfigurer.requestUser();
        this.authorizeGroupService.authorizeInstance(user, AuthenticationConfigurer.requestGroup(), instanceId);
        this.schedJobService.pauseInstance(user, instanceId);
        return Result.success();
    }

    @PostMapping(value={"/instance/cancel"})
    public Result<Void> cancelInstance(@RequestParam(value="instanceId") long instanceId) {
        String user = AuthenticationConfigurer.requestUser();
        this.authorizeGroupService.authorizeInstance(user, AuthenticationConfigurer.requestGroup(), instanceId);
        this.schedJobService.cancelInstance(user, instanceId);
        return Result.success();
    }

    @PostMapping(value={"/instance/resume"})
    public Result<Void> resumeInstance(@RequestParam(value="instanceId") long instanceId) {
        String user = AuthenticationConfigurer.requestUser();
        this.authorizeGroupService.authorizeInstance(user, AuthenticationConfigurer.requestGroup(), instanceId);
        this.schedJobService.resumeInstance(user, instanceId);
        return Result.success();
    }

    @DeleteMapping(value={"/instance/delete"})
    public Result<Void> deleteInstance(@RequestParam(value="instanceId") long instanceId) {
        String user = AuthenticationConfigurer.requestUser();
        this.authorizeGroupService.authorizeInstance(user, AuthenticationConfigurer.requestGroup(), instanceId);
        this.schedJobService.deleteInstance(user, instanceId);
        return Result.success();
    }

    @PostMapping(value={"/instance/state/change"})
    public Result<Void> changeInstanceState(@RequestParam(value="instanceId") long instanceId, @RequestParam(value="targetExecuteState") int targetExecuteState) {
        String user = AuthenticationConfigurer.requestUser();
        this.authorizeGroupService.authorizeInstance(user, AuthenticationConfigurer.requestGroup(), instanceId);
        this.schedJobService.changeInstanceState(user, instanceId, targetExecuteState);
        return Result.success();
    }

    @GetMapping(value={"/instance/get"})
    public Result<SchedInstanceResponse> getInstance(@RequestParam(value="instanceId") long instanceId, @RequestParam(value="includeTasks", defaultValue="false") boolean includeTasks) {
        this.authorizeGroupService.authorizeInstance(AuthenticationConfigurer.requestUser(), AuthenticationConfigurer.requestGroup(), instanceId);
        return Result.success((Object)this.schedJobService.getInstance(instanceId, includeTasks));
    }

    @GetMapping(value={"/instance/tasks"})
    public Result<List<SchedTaskResponse>> getInstanceTasks(@RequestParam(value="instanceId") long instanceId) {
        this.authorizeGroupService.authorizeInstance(AuthenticationConfigurer.requestUser(), AuthenticationConfigurer.requestGroup(), instanceId);
        return Result.success(this.schedJobService.getInstanceTasks(instanceId));
    }

    @GetMapping(value={"/instance/page"})
    public Result<PageResponse<SchedInstanceResponse>> queryInstanceForPage(SchedInstancePageRequest pageRequest) {
        pageRequest.authorize(AuthenticationConfigurer.requestUser(), this.authorizeGroupService);
        return Result.success(this.schedJobService.queryInstanceForPage(pageRequest));
    }

    @GetMapping(value={"/instance/children"})
    public Result<List<SchedInstanceResponse>> listInstanceChildren(@RequestParam(value="pnstanceId") long pnstanceId) {
        this.authorizeGroupService.authorizeInstance(AuthenticationConfigurer.requestUser(), AuthenticationConfigurer.requestGroup(), pnstanceId);
        return Result.success(this.schedJobService.listInstanceChildren(pnstanceId));
    }

    public SupervisorOpenapiProvider(SchedJobService schedJobService, AuthorizeGroupService authorizeGroupService) {
        this.schedJobService = schedJobService;
        this.authorizeGroupService = authorizeGroupService;
    }
}

