/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.disjob.supervisor.provider;

import cn.ponfee.disjob.common.date.Dates;
import cn.ponfee.disjob.common.spring.RpcController;
import cn.ponfee.disjob.core.base.JobConstants;
import cn.ponfee.disjob.core.base.Server;
import cn.ponfee.disjob.core.base.Supervisor;
import cn.ponfee.disjob.core.base.Worker;
import cn.ponfee.disjob.core.dto.supervisor.StartTaskParam;
import cn.ponfee.disjob.core.dto.supervisor.StartTaskResult;
import cn.ponfee.disjob.core.dto.supervisor.StopTaskParam;
import cn.ponfee.disjob.core.enums.Operation;
import cn.ponfee.disjob.core.enums.RegistryEventType;
import cn.ponfee.disjob.registry.SupervisorRegistry;
import cn.ponfee.disjob.supervisor.application.OperationEventService;
import cn.ponfee.disjob.supervisor.auth.SupervisorAuthentication;
import cn.ponfee.disjob.supervisor.base.ExtendedSupervisorRpcService;
import cn.ponfee.disjob.supervisor.base.OperationEventType;
import cn.ponfee.disjob.supervisor.base.SupervisorMetrics;
import cn.ponfee.disjob.supervisor.component.JobManager;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

@RpcController
@SupervisorAuthentication(value=SupervisorAuthentication.Subject.WORKER)
public class SupervisorRpcProvider
implements ExtendedSupervisorRpcService {
    private final SupervisorRegistry supervisorRegistry;
    private final JobManager jobManager;
    private final Supervisor.Local localSupervisor;

    public void subscribeWorkerEvent(RegistryEventType eventType, Worker worker) {
        this.supervisorRegistry.subscribeServerEvent(eventType, (Server)worker);
    }

    public void updateTaskWorker(String worker, List<Long> taskIds) {
        this.jobManager.updateTaskWorker(worker, taskIds);
    }

    public StartTaskResult startTask(StartTaskParam param) {
        return this.jobManager.startTask(param);
    }

    public boolean stopTask(StopTaskParam param) {
        return this.jobManager.stopTask(param);
    }

    public boolean pauseInstance(long instanceId) {
        return this.jobManager.pauseInstance(instanceId);
    }

    public boolean cancelInstance(long instanceId, Operation operation) {
        return this.jobManager.cancelInstance(instanceId, operation);
    }

    public boolean savepoint(long taskId, String worker, String executeSnapshot) {
        return this.jobManager.savepoint(taskId, worker, executeSnapshot);
    }

    @Override
    @SupervisorAuthentication(value=SupervisorAuthentication.Subject.ANON)
    public SupervisorMetrics getMetrics() {
        SupervisorMetrics metrics = new SupervisorMetrics();
        metrics.setVersion(JobConstants.DISJOB_VERSION);
        metrics.setStartupTime(Dates.toDate((LocalDateTime)this.localSupervisor.getStartupTime()));
        metrics.setLastSubscribedEvent(this.localSupervisor.getLastSubscribedEvent());
        metrics.setAlsoWorker(Worker.local() != null);
        return metrics;
    }

    @Override
    @SupervisorAuthentication(value=SupervisorAuthentication.Subject.ANON)
    public void subscribeOperationEvent(OperationEventType eventType, Date eventTime, String eventData) {
        OperationEventService.subscribe(eventType, eventTime, eventData);
    }

    public SupervisorRpcProvider(SupervisorRegistry supervisorRegistry, JobManager jobManager, Supervisor.Local localSupervisor) {
        this.supervisorRegistry = supervisorRegistry;
        this.jobManager = jobManager;
        this.localSupervisor = localSupervisor;
    }
}

