/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.base;

import cn.ponfee.scheduler.common.util.Numbers;
import java.util.Objects;
import java.util.function.Function;

public interface TypedKeyValue<K, V> {
    public V getValue(K var1);

    default public boolean hasKey(K key) {
        return this.getValue(key) != null;
    }

    default public V getRequired(K key) {
        return (V)this.getRequired(key, Function.identity());
    }

    default public V get(K key, V defaultVal) {
        V value = this.getValue(key);
        return value == null ? defaultVal : value;
    }

    default public String getRequiredString(K key) {
        return this.getRequired(key, Object::toString);
    }

    default public String getString(K key) {
        return this.getString(key, null);
    }

    default public String getString(K key, String defaultVal) {
        return Objects.toString(this.getValue(key), defaultVal);
    }

    default public boolean getRequiredBoolean(K key) {
        V value = this.getValue(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value == null) {
            throw new IllegalArgumentException("Not presented value of '" + key + "'");
        }
        switch (value.toString()) {
            case "TRUE": 
            case "True": 
            case "true": {
                return true;
            }
            case "FALSE": 
            case "False": 
            case "false": {
                return false;
            }
        }
        throw new IllegalArgumentException("Invalid boolean value: " + value);
    }

    default public boolean getBoolean(K key, boolean defaultValue) {
        return Numbers.toBoolean(this.getValue(key), defaultValue);
    }

    default public Boolean getBoolean(K key) {
        return Numbers.toWrapBoolean(this.getValue(key));
    }

    default public int getRequiredInt(K key) {
        return this.getRequired(key, Numbers::toInt);
    }

    default public int getInt(K key, int defaultValue) {
        return Numbers.toInt(this.getValue(key), defaultValue);
    }

    default public Integer getInt(K key) {
        return Numbers.toWrapInt(this.getValue(key));
    }

    default public long getRequiredLong(K key) {
        return this.getRequired(key, Numbers::toLong);
    }

    default public long getLong(K key, long defaultValue) {
        return Numbers.toLong(this.getValue(key), defaultValue);
    }

    default public Long getLong(K key) {
        return Numbers.toWrapLong(this.getValue(key));
    }

    default public float getRequiredFloat(K key) {
        return this.getRequired(key, Numbers::toFloat).floatValue();
    }

    default public float getFloat(K key, float defaultValue) {
        return Numbers.toFloat(this.getValue(key), defaultValue);
    }

    default public Float getFloat(K key) {
        return Numbers.toWrapFloat(this.getValue(key));
    }

    default public double getRequiredDouble(K key) {
        return this.getRequired(key, Numbers::toDouble);
    }

    default public double getDouble(K key, double defaultValue) {
        return Numbers.toDouble(this.getValue(key), defaultValue);
    }

    default public Double getDouble(K key) {
        return Numbers.toWrapDouble(this.getValue(key));
    }

    default public <R> R getRequired(K key, Function<V, R> mapper) {
        V value = this.getValue(key);
        if (value == null) {
            throw new IllegalArgumentException("Not presented value of '" + key + "'");
        }
        return mapper.apply(value);
    }
}

