/*
 * Decompiled with CFR 0.152.
 */
package cn.ponfee.scheduler.common.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public class NamedThreadFactory
implements ThreadFactory {
    private static final AtomicInteger POOL_SEQ = new AtomicInteger(1);
    private final AtomicInteger threadNo = new AtomicInteger(1);
    private final String prefix;
    private final Boolean daemon;
    private final Integer priority;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final ThreadGroup group;

    public NamedThreadFactory(String prefix, Boolean daemon, Integer priority, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        if (StringUtils.isBlank((CharSequence)prefix)) {
            prefix = "pool-" + POOL_SEQ.getAndIncrement();
        }
        SecurityManager sm = System.getSecurityManager();
        this.prefix = prefix + "-thread-";
        this.daemon = daemon;
        this.priority = priority;
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
        this.group = sm != null ? sm.getThreadGroup() : Thread.currentThread().getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this.group, runnable, this.prefix + this.threadNo.getAndIncrement(), 0L);
        thread.setDaemon(this.daemon != null ? this.daemon.booleanValue() : Thread.currentThread().isDaemon());
        if (this.priority != null) {
            thread.setPriority(this.priority);
        }
        if (this.uncaughtExceptionHandler != null) {
            thread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        }
        return thread;
    }

    public ThreadGroup getThreadGroup() {
        return this.group;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String prefix;
        private Boolean daemon;
        private Integer priority;
        private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

        private Builder() {
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder daemon(boolean daemon) {
            this.daemon = daemon;
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public Builder prefix(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.uncaughtExceptionHandler = uncaughtExceptionHandler;
            return this;
        }

        public NamedThreadFactory build() {
            return new NamedThreadFactory(this.prefix, this.daemon, this.priority, this.uncaughtExceptionHandler);
        }
    }
}

